/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.StringUtils;
import java.security.CodeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version {
    private static final String VERSION = Version.getVersion(Version.class, "1.0.0");

    private Version() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersion(Class<?> cls) {
        return Version.getVersion(cls, Version.getVersion());
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        try {
            String file;
            CodeSource codeSource;
            String version = cls.getPackage().getImplementationVersion();
            if (StringUtils.isEmpty(version)) {
                version = cls.getPackage().getSpecificationVersion();
            }
            if (StringUtils.isEmpty(version) && (codeSource = cls.getProtectionDomain().getCodeSource()) != null && StringUtils.isNotEmpty(file = codeSource.getLocation().getFile()) && file.endsWith(".jar")) {
                int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
                if (i >= 0) {
                    file = file.substring(i + 1);
                }
                if ((i = file.indexOf("-")) >= 0) {
                    file = file.substring(i + 1);
                }
                while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
                    file = file.substring(i + 1);
                }
                version = file;
            }
            return StringUtils.isEmpty(version) ? defaultVersion : version;
        }
        catch (Throwable e) {
            return defaultVersion;
        }
    }
}

