/*
 * Decompiled with CFR 0.152.
 */
package httl.web;

import httl.Context;
import httl.Engine;
import httl.spi.Logger;
import httl.spi.loaders.ServletLoader;
import httl.spi.resolvers.ServletResolver;
import httl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebEngine {
    private static final String CONFIG_KEY = "httl.properties";
    private static final String WEBINF_CONFIG = "/WEB-INF/httl.properties";
    private static volatile Engine ENGINE;
    private static final Map<String, String> addProperties;
    private static final Map<String, String> setProperties;

    private WebEngine() {
    }

    public static void addProperty(String key, String value) {
        String old = addProperties.get(key);
        if (StringUtils.isNotEmpty(old)) {
            value = old + "," + value;
        }
        addProperties.put(key, value);
    }

    public static void setProperty(String key, String value) {
        setProperties.put(key, value);
    }

    public static String getTemplateSuffix(ServletContext servletContext) {
        WebEngine.setServletContext(servletContext);
        return WebEngine.getTemplateSuffix();
    }

    public static String getTemplateSuffix() {
        if (WebEngine.getServletContext() == null) {
            return ".httl";
        }
        return WebEngine.getEngine().getProperty("template.suffix", new String[]{".httl"})[0];
    }

    public static HttpServletRequest getRequest() {
        return ServletResolver.getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletResolver.getResponse();
    }

    public static void setRequest(HttpServletRequest request) {
        if (request != null && request.getSession() != null) {
            WebEngine.setServletContext(request.getSession().getServletContext());
        }
        ServletResolver.setRequest(request);
    }

    public static void setResponse(HttpServletResponse response) {
        ServletResolver.setResponse(response);
    }

    public static void setRequestAndResponse(HttpServletRequest request, HttpServletResponse response) {
        WebEngine.setRequest(request);
        WebEngine.setResponse(response);
    }

    public static ServletContext getServletContext() {
        return ServletLoader.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setServletContext(ServletContext servletContext) {
        if (servletContext == null) {
            return;
        }
        if (ServletLoader.getServletContext() == null) {
            ServletLoader.setServletContext(servletContext);
        }
        if (ENGINE != null) return;
        Class<WebEngine> clazz = WebEngine.class;
        synchronized (WebEngine.class) {
            if (ENGINE != null) return;
            Properties properties = new Properties();
            String config = servletContext.getInitParameter(CONFIG_KEY);
            if (StringUtils.isBlank(config)) {
                config = WEBINF_CONFIG;
            }
            if ((config = config.trim()).startsWith("/")) {
                InputStream in = servletContext.getResourceAsStream(config);
                if (in != null) {
                    try {
                        properties.load(in);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to load httl config " + config + " in wepapp. cause: " + e.getMessage(), e);
                    }
                } else {
                    if (StringUtils.isNotBlank(servletContext.getInitParameter(CONFIG_KEY))) {
                        throw new IllegalStateException("Not found httl config " + config + " in wepapp.");
                    }
                    config = null;
                }
            } else if (config.startsWith("classpath:")) {
                config = config.substring("classpath:".length());
                config.replaceFirst("^/+", "");
            } else if (config.startsWith("file:")) {
                config = config.substring("file:".length());
                config.replaceFirst("^/+", "/");
                if (!config.startsWith("/") && !config.startsWith(".")) {
                    config = "/" + config;
                }
            }
            ENGINE = Engine.getEngine(config, WebEngine.addProperties(properties));
            WebEngine.logConfigPath(ENGINE, servletContext, config);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void logConfigPath(Engine engine, ServletContext servletContext, String path) {
        Logger logger;
        if (engine != null && servletContext != null && path != null && (logger = engine.getProperty("logger", Logger.class)) != null && logger.isInfoEnabled()) {
            String name = engine.getName();
            try {
                if (name != null && name.startsWith("/") && servletContext.getResource(name) != null) {
                    logger.info("Load httl config form " + servletContext.getRealPath(name) + " in webapp.");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static Properties addProperties(Properties properties) {
        String key;
        Properties def = new Properties();
        InputStream in = Engine.class.getClassLoader().getResourceAsStream("httl-default.properties");
        if (in != null) {
            try {
                def.load(in);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load httl-default.properties. cause: " + e.getMessage());
            }
        }
        for (Map.Entry<String, String> entry : addProperties.entrySet()) {
            key = entry.getKey();
            if (properties.containsKey(key)) continue;
            String values = def.getProperty(key, "");
            if (values.length() > 0) {
                values = "," + values;
            }
            properties.setProperty(key, entry.getValue() + values);
        }
        for (Map.Entry<String, String> entry : setProperties.entrySet()) {
            key = entry.getKey();
            if (properties.containsKey(key)) continue;
            properties.setProperty(key, entry.getValue());
        }
        return properties;
    }

    public static Engine getEngine() {
        if (ENGINE == null) {
            Object request = Context.getContext().get("request");
            if (request instanceof HttpServletRequest && ((HttpServletRequest)request).getSession() != null) {
                WebEngine.setServletContext(((HttpServletRequest)request).getSession().getServletContext());
            } else {
                WebEngine.setServletContext(ServletLoader.getAndCheckServletContext());
            }
        }
        return ENGINE;
    }

    static {
        addProperties = new ConcurrentHashMap<String, String>();
        setProperties = new ConcurrentHashMap<String, String>();
        WebEngine.addProperty("modes", "web");
    }
}

