/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ;

import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.TemplateHandler;
import io.vertx.ext.web.templ.MVELTemplateEngine;
import io.vertx.ext.web.templ.TemplateEngine;
import java.io.File;
import java.io.PrintWriter;
import org.junit.Test;

public class MVELTemplateNoCacheTest
extends WebTestBase {
    protected VertxOptions getOptions() {
        return new VertxOptions().setFileResolverCachingEnabled(false);
    }

    private void testTemplateHandler(TemplateEngine engine, String directoryName, String templateName, String expected) throws Exception {
        this.router.route().handler(context -> {
            context.put("foo", (Object)"badger");
            context.put("bar", (Object)"fox");
            context.next();
        });
        this.router.route().handler((Handler)TemplateHandler.create((TemplateEngine)engine, (String)directoryName, (String)"text/plain"));
        this.testRequest(HttpMethod.GET, "/" + templateName, 200, "OK", expected);
    }

    @Test
    public void testCachingDisabled() throws Exception {
        System.setProperty("io.vertx.ext.web.TemplateEngine.disableCache", "true");
        MVELTemplateEngine engine = MVELTemplateEngine.create();
        File temp = File.createTempFile("template", ".templ", new File("target/classes"));
        temp.deleteOnExit();
        PrintWriter out = new PrintWriter(temp);
        out.print("before");
        out.flush();
        out.close();
        this.testTemplateHandler((TemplateEngine)engine, ".", temp.getName(), "before");
        out = new PrintWriter(temp);
        out.print("after");
        out.flush();
        out.close();
        this.testTemplateHandler((TemplateEngine)engine, ".", temp.getName(), "after");
    }
}

