/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ;

import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.TemplateHandler;
import io.vertx.ext.web.templ.MVELTemplateEngine;
import io.vertx.ext.web.templ.TemplateEngine;
import java.io.File;
import java.io.PrintWriter;
import org.junit.Test;

public class MVELTemplateTest
extends WebTestBase {
    protected VertxOptions getOptions() {
        return new VertxOptions().setFileResolverCachingEnabled(true);
    }

    @Test
    public void testTemplateHandlerOnClasspath() throws Exception {
        MVELTemplateEngine engine = MVELTemplateEngine.create();
        this.testTemplateHandler((TemplateEngine)engine, "somedir", "test-mvel-template2.templ", "Hello badger and fox\nRequest path is /test-mvel-template2.templ");
    }

    @Test
    public void MVELTemplateTestMVELTemplateTestMVELTemplateTest() throws Exception {
        MVELTemplateEngine engine = MVELTemplateEngine.create();
        this.testTemplateHandler((TemplateEngine)engine, "src/test/filesystemtemplates", "test-mvel-template3.templ", "Hello badger and fox\nRequest path is /test-mvel-template3.templ");
    }

    @Test
    public void testTemplateHandlerWithInclude() throws Exception {
        MVELTemplateEngine engine = MVELTemplateEngine.create();
        this.testTemplateHandler((TemplateEngine)engine, "src/test/filesystemtemplates", "test-mvel-template4.templ", "Hello badger and fox\nRequest path is /test-mvel-template4.templ");
    }

    @Test
    public void testTemplateHandlerOnClasspathDisableCaching() throws Exception {
        System.setProperty("io.vertx.ext.web.TemplateEngine.disableCache", "true");
        this.testTemplateHandlerOnClasspath();
    }

    @Test
    public void testTemplateHandlerNoExtension() throws Exception {
        MVELTemplateEngine engine = MVELTemplateEngine.create();
        this.testTemplateHandler((TemplateEngine)engine, "somedir", "test-mvel-template2", "Hello badger and fox\nRequest path is /test-mvel-template2");
    }

    @Test
    public void testTemplateHandlerChangeExtension() throws Exception {
        MVELTemplateEngine engine = MVELTemplateEngine.create().setExtension("bempl");
        this.testTemplateHandler((TemplateEngine)engine, "somedir", "test-mvel-template2", "Cheerio badger and fox\nRequest path is /test-mvel-template2");
    }

    private void testTemplateHandler(TemplateEngine engine, String directoryName, String templateName, String expected) throws Exception {
        this.router.route().handler(context -> {
            context.put("foo", (Object)"badger");
            context.put("bar", (Object)"fox");
            context.next();
        });
        this.router.route().handler((Handler)TemplateHandler.create((TemplateEngine)engine, (String)directoryName, (String)"text/plain"));
        this.testRequest(HttpMethod.GET, "/" + templateName, 200, "OK", expected);
    }

    @Test
    public void testNoSuchTemplate() throws Exception {
        MVELTemplateEngine engine = MVELTemplateEngine.create();
        this.router.route().handler((Handler)TemplateHandler.create((TemplateEngine)engine, (String)"nosuchtemplate.templ", (String)"text/plain"));
        this.testRequest(HttpMethod.GET, "/foo.templ", 500, "Internal Server Error");
    }

    @Test
    public void testCachingEnabled() throws Exception {
        System.setProperty("io.vertx.ext.web.TemplateEngine.disableCache", "false");
        MVELTemplateEngine engine = MVELTemplateEngine.create();
        File temp = File.createTempFile("template", ".templ", new File("target/classes"));
        temp.deleteOnExit();
        PrintWriter out = new PrintWriter(temp);
        out.print("before");
        out.flush();
        out.close();
        this.testTemplateHandler((TemplateEngine)engine, ".", temp.getName(), "before");
        out = new PrintWriter(temp);
        out.print("after");
        out.flush();
        out.close();
        this.testTemplateHandler((TemplateEngine)engine, ".", temp.getName(), "before");
    }
}

