/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.templ.rythm.RythmTemplateEngine;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import junit.framework.TestCase;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RythmTemplateTest {
    private static Vertx vertx;

    @BeforeClass
    public static void before() {
        vertx = Vertx.vertx((VertxOptions)new VertxOptions().setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(true)));
    }

    @Test
    public void testTemplateHandlerOnClasspath(TestContext should) {
        RythmTemplateEngine engine = RythmTemplateEngine.create((Vertx)vertx);
        JsonObject context = new JsonObject().put("foo", (Object)"badger").put("bar", (Object)"fox");
        engine.render(context, "somedir/test-rythm-template2.html", should.asyncAssertSuccess(render -> {
            String expected = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<meta charset=\"UTF-8\">\n<title>Title</title>\n</head>\n<body>\n<p>badger</p>\n<p>fox</p>\n</body>\n</html>\n";
            should.assertEquals((Object)"<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<meta charset=\"UTF-8\">\n<title>Title</title>\n</head>\n<body>\n<p>badger</p>\n<p>fox</p>\n</body>\n</html>\n", (Object)RythmTemplateTest.normalizeCRLF(render.toString()));
        }));
    }

    @Test
    public void testTemplateHandlerOnFileSystem(TestContext should) {
        RythmTemplateEngine engine = RythmTemplateEngine.create((Vertx)vertx);
        JsonObject context = new JsonObject().put("foo", (Object)"badger").put("bar", (Object)"fox");
        engine.render(context, "src/test/filesystemtemplates/test-rythm-template.html", should.asyncAssertSuccess(render -> {
            String expected = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<meta charset=\"UTF-8\">\n<title>FS</title>\n</head>\n<body>\n<p>badger</p>\n<p>fox</p>\n</body>\n</html>\n";
            should.assertEquals((Object)"<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<meta charset=\"UTF-8\">\n<title>FS</title>\n</head>\n<body>\n<p>badger</p>\n<p>fox</p>\n</body>\n</html>\n", (Object)RythmTemplateTest.normalizeCRLF(render.toString()));
        }));
    }

    @Test
    public void testTemplateHandlerOnClasspathDisableCaching(TestContext should) {
        System.setProperty("vertxweb.environment", "development");
        this.testTemplateHandlerOnClasspath(should);
    }

    @Test
    public void testNoSuchTemplate(TestContext should) {
        RythmTemplateEngine engine = RythmTemplateEngine.create((Vertx)vertx);
        JsonObject context = new JsonObject();
        engine.render(context, "nosuchtemplate.html", should.asyncAssertFailure());
    }

    @Test
    public void testWithLocale(TestContext should) {
        RythmTemplateEngine engine = RythmTemplateEngine.create((Vertx)vertx);
        JsonObject context = new JsonObject().put("foo", (Object)"badger").put("bar", (Object)"fox").put("lang", (Object)"en-gb");
        engine.render(context, "somedir/test-rythm-template2.html", should.asyncAssertSuccess(render -> {
            String expected = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<meta charset=\"UTF-8\">\n<title>Title</title>\n</head>\n<body>\n<p>badger</p>\n<p>fox</p>\n</body>\n</html>\n";
            should.assertEquals((Object)"<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<meta charset=\"UTF-8\">\n<title>Title</title>\n</head>\n<body>\n<p>badger</p>\n<p>fox</p>\n</body>\n</html>\n", (Object)RythmTemplateTest.normalizeCRLF(render.toString()));
        }));
    }

    @Test
    public void testEngine() {
        RythmTemplateEngine engine = RythmTemplateEngine.create((Vertx)vertx);
        TestCase.assertNotNull((Object)engine.unwrap());
    }

    @Test
    public void testCachingEnabled(TestContext should) throws IOException {
        System.setProperty("vertxweb.environment", "production");
        RythmTemplateEngine engine = RythmTemplateEngine.create((Vertx)vertx);
        File temp = File.createTempFile("template", ".html", new File("target/classes"));
        temp.deleteOnExit();
        try (PrintWriter out = new PrintWriter(temp);){
            out.print("before");
            out.flush();
        }
        engine.render(new JsonObject(), temp.getParent() + "/" + temp.getName(), should.asyncAssertSuccess(arg_0 -> RythmTemplateTest.lambda$testCachingEnabled$4(should, temp, (TemplateEngine)engine, arg_0)));
    }

    static String normalizeCRLF(String s) {
        return s.replace("\r\n", "\n");
    }

    private static /* synthetic */ void lambda$testCachingEnabled$4(TestContext should, File temp, TemplateEngine engine, Buffer render) {
        should.assertEquals((Object)"before", (Object)RythmTemplateTest.normalizeCRLF(render.toString()));
        try (PrintWriter out2 = new PrintWriter(temp);){
            out2.print("after");
            out2.flush();
        }
        catch (IOException e) {
            should.fail((Throwable)e);
        }
        engine.render(new JsonObject(), temp.getParent() + "/" + temp.getName(), should.asyncAssertSuccess(render2 -> should.assertEquals((Object)"before", (Object)RythmTemplateTest.normalizeCRLF(render2.toString()))));
    }
}

