/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.impl.Utils;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.junit.Test;

public class CookieHandlerTest
extends WebTestBase {
    private final DateFormat dateTimeFormat = Utils.createRFC1123DateTimeFormatter();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.router.route().handler((Handler)CookieHandler.create());
    }

    @Test
    public void testSimpleCookie() throws Exception {
        this.router.route().handler(rc -> {
            this.assertEquals(1L, rc.cookieCount());
            Cookie cookie = rc.getCookie("foo");
            this.assertNotNull(cookie);
            this.assertEquals("bar", cookie.getValue());
            rc.response().end();
        });
        this.testRequestWithCookies(HttpMethod.GET, "/", "foo=bar", 200, "OK");
    }

    @Test
    public void testGetCookies() throws Exception {
        this.router.route().handler(rc -> {
            this.assertEquals(3L, rc.cookieCount());
            Set cookies = rc.cookies();
            this.assertTrue(this.contains(cookies, "foo"));
            this.assertTrue(this.contains(cookies, "wibble"));
            this.assertTrue(this.contains(cookies, "plop"));
            rc.removeCookie("foo");
            cookies = rc.cookies();
            this.assertFalse(this.contains(cookies, "foo"));
            this.assertTrue(this.contains(cookies, "wibble"));
            this.assertTrue(this.contains(cookies, "plop"));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().set("Cookie", "foo=bar; wibble=blibble; plop=flop"), resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        }, 200, "OK", null);
    }

    private boolean contains(Set<Cookie> cookies, String name) {
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testCookiesChangedInHandler() throws Exception {
        this.router.route().handler(rc -> {
            this.assertEquals(3L, rc.cookieCount());
            this.assertEquals("bar", rc.getCookie("foo").getValue());
            this.assertEquals("blibble", rc.getCookie("wibble").getValue());
            this.assertEquals("flop", rc.getCookie("plop").getValue());
            rc.removeCookie("plop");
            this.assertEquals(2L, rc.cookieCount());
            rc.next();
        });
        this.router.route().handler(rc -> {
            this.assertEquals(2L, rc.cookieCount());
            this.assertEquals("bar", rc.getCookie("foo").getValue());
            this.assertEquals("blibble", rc.getCookie("wibble").getValue());
            this.assertNull(rc.getCookie("plop"));
            rc.addCookie(Cookie.cookie((String)"fleeb", (String)"floob"));
            this.assertEquals(3L, rc.cookieCount());
            this.assertNull(rc.removeCookie("blarb"));
            this.assertEquals(3L, rc.cookieCount());
            Cookie foo = rc.getCookie("foo");
            foo.setValue("blah");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", req -> req.headers().set("Cookie", "foo=bar; wibble=blibble; plop=flop"), resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(2L, cookies.size());
            this.assertTrue(cookies.contains("foo=blah"));
            this.assertTrue(cookies.contains("fleeb=floob"));
        }, 200, "OK", null);
    }

    @Test
    public void testCookieFields() throws Exception {
        Cookie cookie = Cookie.cookie((String)"foo", (String)"bar");
        this.assertEquals("foo", cookie.getName());
        this.assertEquals("bar", cookie.getValue());
        this.assertEquals("foo=bar", cookie.encode());
        this.assertNull(cookie.getPath());
        cookie.setPath("/somepath");
        this.assertEquals("/somepath", cookie.getPath());
        this.assertEquals("foo=bar; Path=/somepath", cookie.encode());
        this.assertNull(cookie.getDomain());
        cookie.setDomain("foo.com");
        this.assertEquals("foo.com", cookie.getDomain());
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com", cookie.encode());
        long maxAge = 1800L;
        cookie.setMaxAge(maxAge);
        long now = System.currentTimeMillis();
        String encoded = cookie.encode();
        int startPos = encoded.indexOf("Expires=");
        int endPos = encoded.indexOf(59, startPos);
        String expiresDate = encoded.substring(startPos + 8, endPos);
        Date d = this.dateTimeFormat.parse(expiresDate);
        this.assertTrue(d.getTime() - now >= maxAge);
        cookie.setMaxAge(Long.MIN_VALUE);
        cookie.setSecure(true);
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com; Secure", cookie.encode());
        cookie.setHttpOnly(true);
        this.assertEquals("foo=bar; Path=/somepath; Domain=foo.com; Secure; HTTPOnly", cookie.encode());
    }
}

