/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class OAuth2AuthHandlerTest
extends WebTestBase {
    private static final JsonObject fixture = new JsonObject("{  \"access_token\": \"4adc339e0\",  \"refresh_token\": \"ec1a59d298\",  \"token_type\": \"bearer\",  \"expires_in\": 7200}");
    private String redirectURL = null;

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testHappyFlow() throws Exception {
        OAuth2Auth oauth2 = OAuth2Auth.create((Vertx)this.vertx, (OAuth2FlowType)OAuth2FlowType.AUTH_CODE, (OAuth2ClientOptions)new OAuth2ClientOptions().setClientID("client-id").setClientSecret("client-secret").setSite("http://localhost:10000"));
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer server = this.vertx.createHttpServer().requestHandler(req -> {
            if (req.method() == HttpMethod.POST && "/oauth/token".equals(req.path())) {
                req.setExpectMultipart(true).bodyHandler(buffer -> req.response().putHeader("Content-Type", "application/json").end(fixture.encode()));
            } else if (req.method() == HttpMethod.POST && "/oauth/revoke".equals(req.path())) {
                req.setExpectMultipart(true).bodyHandler(buffer -> req.response().end());
            } else {
                req.response().setStatusCode(400).end();
            }
        }).listen(10000, ready -> {
            if (ready.failed()) {
                throw new RuntimeException(ready.cause());
            }
            latch.countDown();
        });
        latch.await();
        OAuth2AuthHandler oauth2Handler = OAuth2AuthHandler.create((OAuth2Auth)oauth2, (String)"http://localhost:8080/callback");
        oauth2Handler.setupCallback(this.router.route());
        this.router.route("/protected/*").handler((Handler)oauth2Handler);
        this.router.route("/protected/somepage").handler(rc -> {
            this.assertNotNull(rc.user());
            rc.response().end("Welcome to the protected resource!");
        });
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            this.redirectURL = resp.getHeader("Location");
            this.assertNotNull(this.redirectURL);
        }, 302, "Found", null);
        this.testRequest(HttpMethod.GET, "/callback?state=/protected/somepage&code=1", null, resp -> {}, 200, "OK", "Welcome to the protected resource!");
        server.close();
    }
}

