/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.ext.web.LRUCacheTestBase;
import io.vertx.ext.web.impl.ConcurrentLRUCache;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentLRUCacheTest
extends LRUCacheTestBase {
    @Override
    protected Map<String, String> createCache() {
        return new ConcurrentLRUCache(this.maxSize);
    }

    @Override
    @Test
    public void testPut() {
        super.testPut();
        Assert.assertEquals((long)this.maxSize, (long)((ConcurrentLRUCache)this.cache).queueSize());
    }

    @Override
    @Test
    public void testRemove() {
        super.testRemove();
        Assert.assertEquals((long)0L, (long)((ConcurrentLRUCache)this.cache).queueSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCacheInvalidSize1() {
        new ConcurrentLRUCache(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCacheInvalidSize2() {
        new ConcurrentLRUCache(-1);
    }

    @Test
    public void testIncreaseMaxSize() {
        for (int i = 0; i < this.maxSize; ++i) {
            this.cache.put("key" + i, "value" + i);
        }
        Assert.assertEquals((long)this.maxSize, (long)this.cache.size());
        ConcurrentLRUCache ccache = (ConcurrentLRUCache)this.cache;
        ccache.setMaxSize(this.maxSize + 10);
        for (int i = this.maxSize; i < this.maxSize + 10; ++i) {
            this.cache.put("key" + i, "value" + i);
        }
        Assert.assertEquals((long)(this.maxSize + 10), (long)this.cache.size());
    }
}

