/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.WebTestBase;
import org.junit.Test;

public class SubRouterTest
extends WebTestBase {
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMountPoint1() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath*", subRouter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMountPoint2() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath/*", subRouter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMountPoint3() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("subpath", subRouter);
    }

    @Test
    public void testSimple() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo", 200, "/subpath/foo");
        this.testRequest(HttpMethod.GET, "/subpath/", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/subpath/bar", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/otherpath", 404, "Not Found");
    }

    @Test
    public void testTrailingSlash() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath/", subRouter);
        subRouter.route("/foo").handler(rc -> {
            this.assertEquals("/subpath/", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo", 200, "/subpath/foo");
        this.testRequest(HttpMethod.GET, "/subpath/", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/subpath/bar", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/otherpath", 404, "Not Found");
    }

    @Test
    public void testMultiple() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        subRouter.route("/bar").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        subRouter.route("/wibble").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo", 200, "/subpath/foo");
        this.testRequest(HttpMethod.GET, "/subpath/bar", 200, "/subpath/bar");
        this.testRequest(HttpMethod.GET, "/subpath/wibble", 200, "/subpath/wibble");
        this.testRequest(HttpMethod.GET, "/subpath/", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/subpath/other", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/otherpath", 404, "Not Found");
    }

    @Test
    public void testMultiple2() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.route("/otherpath1").handler(rc -> rc.response().setStatusMessage(rc.request().path()).end());
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        subRouter.route("/bar").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        subRouter.route("/wibble").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        this.router.route("/otherpath2").handler(rc -> {
            this.assertNull(rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo", 200, "/subpath/foo");
        this.testRequest(HttpMethod.GET, "/subpath/bar", 200, "/subpath/bar");
        this.testRequest(HttpMethod.GET, "/subpath/wibble", 200, "/subpath/wibble");
        this.testRequest(HttpMethod.GET, "/otherpath1", 200, "/otherpath1");
        this.testRequest(HttpMethod.GET, "/otherpath2", 200, "/otherpath2");
        this.testRequest(HttpMethod.GET, "/subpath/", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/otherpath3", 404, "Not Found");
    }

    @Test
    public void testChain() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().setChunked(true);
            rc.response().write("apples");
            rc.next();
        });
        subRouter.route("/foo").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().write("oranges");
            rc.next();
        });
        subRouter.route("/foo").handler(rc -> {
            this.assertEquals("/subpath", rc.mountPoint());
            rc.response().write("bananas");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo", 200, "OK", "applesorangesbananas");
        this.testRequest(HttpMethod.GET, "/subpath/", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/subpath/other", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/otherpath", 404, "Not Found");
    }

    @Test
    public void testChain2() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.route("/foo/*").handler(rc -> {
            rc.response().setChunked(true);
            rc.response().write("red");
            rc.next();
        });
        this.router.mountSubRouter("/foo", subRouter);
        subRouter.route("/bar").handler(rc -> {
            this.assertEquals("/foo", rc.mountPoint());
            rc.response().write("apples");
            rc.next();
        });
        subRouter.route("/bar").handler(rc -> {
            this.assertEquals("/foo", rc.mountPoint());
            rc.response().write("oranges");
            rc.next();
        });
        subRouter.route("/bar").handler(rc -> {
            this.assertEquals("/foo", rc.mountPoint());
            rc.response().write("bananas");
            rc.next();
        });
        this.router.route("/foo/*").handler(rc -> {
            this.assertNull(rc.mountPoint());
            rc.response().write("pie");
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/foo/bar", 200, "OK", "redapplesorangesbananaspie");
        this.testRequest(HttpMethod.GET, "/otherpath", 404, "Not Found");
    }

    @Test
    public void testMultipleSubrouters() throws Exception {
        Router subRouter1 = Router.router((Vertx)this.vertx);
        Router subRouter2 = Router.router((Vertx)this.vertx);
        Router subRouter3 = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/foo", subRouter1);
        subRouter1.mountSubRouter("/bar", subRouter2);
        subRouter2.mountSubRouter("/wibble", subRouter3);
        subRouter3.route("/eek").handler(rc -> {
            this.assertEquals("/foo/bar/wibble", rc.mountPoint());
            rc.response().setStatusMessage(rc.request().path()).end();
        });
        this.testRequest(HttpMethod.GET, "/foo/bar/wibble/eek", 200, "/foo/bar/wibble/eek");
        this.testRequest(HttpMethod.GET, "/foo", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/foo/bar", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/foo/bar/wibble", 404, "Not Found");
    }

    @Test
    public void testEmptySubrouter() throws Exception {
        Router subRouter1 = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/foo", subRouter1);
        this.testRequest(HttpMethod.GET, "/foo", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/foo/bar", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/foo/bar/wibble", 404, "Not Found");
    }

    @Test
    public void testSubroutersState() throws Exception {
        Router subRouter1 = Router.router((Vertx)this.vertx);
        Router subRouter2 = Router.router((Vertx)this.vertx);
        Router subRouter3 = Router.router((Vertx)this.vertx);
        this.router.route("/foo/*").handler(rc -> {
            rc.put("key0", (Object)"blah0");
            rc.next();
        });
        this.router.mountSubRouter("/foo", subRouter1);
        subRouter1.route("/bar/*").handler(rc -> {
            rc.put("key1", (Object)"blah1");
            rc.next();
        });
        subRouter1.mountSubRouter("/bar", subRouter2);
        subRouter2.route("/wibble/*").handler(rc -> {
            rc.put("key2", (Object)"blah2");
            rc.next();
        });
        subRouter2.mountSubRouter("/wibble", subRouter3);
        subRouter3.route("/eek").handler(rc -> {
            this.assertEquals("/foo/bar/wibble", rc.mountPoint());
            rc.put("key3", (Object)"blah3");
            rc.next();
        });
        this.router.route("/foo/*").handler(rc -> {
            this.assertEquals("blah0", rc.get("key0"));
            this.assertEquals("blah1", rc.get("key1"));
            this.assertEquals("blah2", rc.get("key2"));
            this.assertEquals("blah3", rc.get("key3"));
            rc.response().setStatusMessage(rc.currentRoute().getPath()).end();
        });
        this.testRequest(HttpMethod.GET, "/foo/bar/wibble/eek", 200, "/foo/");
    }

    @Test
    public void testUnhandledRuntimeException() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo").handler(rc -> {
            throw new RuntimeException("Balderdash!");
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo", 500, "Internal Server Error");
    }

    @Test
    public void tesHandledRuntimeException1() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo/*").handler(rc -> {
            throw new RuntimeException("Balderdash!");
        });
        this.router.route("/subpath/*").failureHandler(rc -> {
            this.assertEquals(500L, rc.statusCode());
            this.assertEquals("Balderdash!", rc.failure().getMessage());
            rc.response().setStatusCode(555).setStatusMessage("Badgers").end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo/bar", 555, "Badgers");
    }

    @Test
    public void tesHandledRuntimeException2() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo/*").handler(rc -> {
            throw new RuntimeException("Balderdash!");
        });
        subRouter.route("/foo/*").failureHandler(rc -> {
            this.assertEquals(500L, rc.statusCode());
            this.assertEquals("Balderdash!", rc.failure().getMessage());
            rc.response().setStatusCode(555).setStatusMessage("Badgers").end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo/bar", 555, "Badgers");
    }

    @Test
    public void testFailCalled1() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo/*").handler(rc -> rc.fail(557));
        this.router.route("/subpath/*").failureHandler(rc -> {
            this.assertEquals(557L, rc.statusCode());
            this.assertNull(rc.failure());
            rc.response().setStatusCode(rc.statusCode()).setStatusMessage("Chipmunks").end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo/bar", 557, "Chipmunks");
    }

    @Test
    public void testFailCalled2() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/subpath", subRouter);
        subRouter.route("/foo/*").handler(rc -> rc.fail(557));
        this.router.route("/subpath/*").failureHandler(rc -> {
            this.assertEquals(557L, rc.statusCode());
            this.assertNull(rc.failure());
            rc.response().setStatusCode(rc.statusCode()).setStatusMessage("Chipmunks").end();
        });
        this.testRequest(HttpMethod.GET, "/subpath/foo/bar", 557, "Chipmunks");
    }

    @Test
    public void testSubRoutePattern() {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/foo/:abc/bar", subRouter);
    }

    @Test
    public void testSubRouteRegex() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.routeWithRegex("/foo/.*").handler(arg_0 -> ((Router)subRouter).handleContext(arg_0)).failureHandler(arg_0 -> ((Router)subRouter).handleFailure(arg_0));
        subRouter.route("/blah").handler(rc -> rc.response().setStatusMessage("sausages").end());
        this.testRequest(HttpMethod.GET, "/foo/blah", 500, "Internal Server Error");
    }

    @Test
    public void testRegexInSubRouter() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/api", subRouter);
        subRouter.routeWithRegex("\\/test").handler(rc -> rc.response().setStatusMessage("sausages").end());
        this.testRequest(HttpMethod.GET, "/api/test", 200, "sausages");
    }

    @Test
    public void testNormalized1() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/api", subRouter);
        subRouter.route("/foo").handler(rc -> rc.response().setStatusMessage("sausages").end());
        this.testRequest(HttpMethod.GET, "/api/foo", 200, "sausages");
        this.testRequest(HttpMethod.GET, "/api/foo/", 200, "sausages");
        this.testRequest(HttpMethod.GET, "/api/foo//", 200, "sausages");
        this.testRequest(HttpMethod.GET, "//api//foo//", 200, "sausages");
        this.testRequest(HttpMethod.GET, "//api//foo///", 200, "sausages");
    }

    @Test
    public void testNormalized2() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/api/", subRouter);
        subRouter.route("/foo").handler(rc -> rc.response().setStatusMessage("sausages").end());
        this.testRequest(HttpMethod.GET, "/api/foo", 200, "sausages");
        this.testRequest(HttpMethod.GET, "/api/foo/", 200, "sausages");
        this.testRequest(HttpMethod.GET, "/api/foo//", 200, "sausages");
        this.testRequest(HttpMethod.GET, "//api//foo//", 200, "sausages");
        this.testRequest(HttpMethod.GET, "//api//foo///", 200, "sausages");
    }

    @Test
    public void testNormalized3() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/api", subRouter);
        subRouter.route("/").handler(rc -> rc.response().setStatusMessage("sausages").end());
        this.testRequest(HttpMethod.GET, "/api/", 200, "sausages");
        this.testRequest(HttpMethod.GET, "/api", 200, "sausages");
        this.testRequest(HttpMethod.GET, "/api///", 200, "sausages");
        this.testRequest(HttpMethod.GET, "//api//", 200, "sausages");
    }

    @Test
    public void testNormalized4() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/api/", subRouter);
        subRouter.route("/").handler(rc -> rc.response().setStatusMessage("sausages").end());
        this.testRequest(HttpMethod.GET, "/api/", 200, "sausages");
        this.testRequest(HttpMethod.GET, "/api", 404, "Not Found");
        this.testRequest(HttpMethod.GET, "/api///", 200, "sausages");
        this.testRequest(HttpMethod.GET, "//api//", 200, "sausages");
    }

    @Test
    public void testStackOverflow() throws Exception {
        this.router.get("/files/:id/info").handler(ctx -> ctx.response().end());
        this.router.mountSubRouter("/v1", this.router);
        this.testRequest(HttpMethod.GET, "/v1/files/some-file-id/info", 200, "OK");
        this.testRequest(HttpMethod.GET, "/v1/files//info", 404, "Not Found");
    }

    @Test
    public void testSimpleWithParams() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        subRouter.get("/files/:id/info").handler(ctx -> {
            this.assertEquals("1", ctx.pathParam("version"));
            this.assertEquals("2", ctx.pathParam("id"));
            ctx.response().end();
        });
        this.router.mountSubRouter("/v/:version", subRouter);
        this.testRequest(HttpMethod.GET, "/v/1/files/2/info", 200, "OK");
    }

    @Test(expected=IllegalStateException.class)
    public void testSubRouterExclusive() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        subRouter.get("/files/:id/info").handler(ctx -> {
            this.assertEquals("1", ctx.pathParam("version"));
            this.assertEquals("2", ctx.pathParam("id"));
            ctx.response().end();
        });
        this.router.route("/v/:version/*").subRouter(subRouter).handler(ctx -> {});
    }

    @Test(expected=IllegalStateException.class)
    public void testSubRouterExclusive2() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        subRouter.get("/files/:id/info").handler(ctx -> {
            this.assertEquals("1", ctx.pathParam("version"));
            this.assertEquals("2", ctx.pathParam("id"));
            ctx.response().end();
        });
        this.router.route("/v/:version/*").handler(ctx -> {}).subRouter(subRouter);
    }

    @Test(expected=IllegalStateException.class)
    public void testSubRouterDuplicateVariable() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        subRouter.get("/:id").handler(null);
        this.router.route("/v/:id*").subRouter(subRouter);
    }

    @Test(expected=IllegalStateException.class)
    public void testSubRouterDuplicateVariableLaterStage() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        this.router.route("/v/:id*").subRouter(subRouter);
        subRouter.get("/:id").handler(null);
    }

    @Test
    public void testSubRouterWithRegex() {
        Router router = Router.router((Vertx)this.vertx);
        router.getWithRegex("some-regex").handler(null);
        router.mountSubRouter("/", router);
    }

    @Test
    public void testStrictSlashSubRouter() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        subRouter.get("/files/info").handler(ctx -> ctx.response().end());
        this.router.mountSubRouter("/v/", subRouter);
        this.testRequest(HttpMethod.GET, "/v/files/info", 200, "OK");
    }

    @Test
    public void testMountOnRoot() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        subRouter.get("/primary").handler(ctx -> ctx.response().setStatusMessage("Hi").end());
        this.router.mountSubRouter("/", subRouter);
        this.testRequest(HttpMethod.GET, "/primary", 200, "Hi");
        this.testRequest(HttpMethod.GET, "/primary?query=1", 200, "Hi");
        this.testRequest(HttpMethod.GET, "/primary/", 200, "Hi");
        this.testRequest(HttpMethod.GET, "/primary/random", 404, "Not Found");
    }

    @Test
    public void testWrongMethodSubRouter() throws Exception {
        Router subRouter = Router.router((Vertx)this.vertx);
        subRouter.post("/order/deposit").handler(ctx -> ctx.response().end());
        this.router.mountSubRouter("/bank", subRouter);
        this.testRequest(HttpMethod.POST, "/bank/order/deposit", 200, "OK");
        this.testRequest(HttpMethod.GET, "/bank/order/deposit", 405, "Method Not Allowed");
    }

    @Test
    public void testMountMultiLevel() throws Exception {
        Router routerFirstLevel = Router.router((Vertx)this.vertx);
        this.router.mountSubRouter("/primary", routerFirstLevel);
        Router routerSecondLevel = Router.router((Vertx)this.vertx);
        routerSecondLevel.get("/").handler(ctx -> ctx.response().setStatusMessage("Hi").end());
        routerFirstLevel.mountSubRouter("/", routerSecondLevel);
        this.testRequest(HttpMethod.GET, "/primary", 200, "Hi");
        this.testRequest(HttpMethod.GET, "/primary?query=1", 200, "Hi");
        this.testRequest(HttpMethod.GET, "/primary/", 200, "Hi");
        this.testRequest(HttpMethod.GET, "/primary/random", 404, "Not Found");
    }
}

