/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.Router;
import io.vertx.test.core.VertxTestBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;

public class WebTestBase
extends VertxTestBase {
    protected static Set<HttpMethod> METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.DELETE, HttpMethod.GET, HttpMethod.HEAD, HttpMethod.PATCH, HttpMethod.OPTIONS, HttpMethod.TRACE, HttpMethod.POST, HttpMethod.PUT));
    protected HttpServer server;
    protected HttpClient client;
    protected Router router;

    public void setUp() throws Exception {
        super.setUp();
        this.router = Router.router((Vertx)this.vertx);
        this.server = this.vertx.createHttpServer(this.getHttpServerOptions());
        this.client = this.vertx.createHttpClient(this.getHttpClientOptions());
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler((Handler)this.router).listen(this.onSuccess(res -> latch.countDown()));
        this.awaitLatch(latch);
    }

    protected HttpServerOptions getHttpServerOptions() {
        return new HttpServerOptions().setPort(8080).setHost("localhost");
    }

    protected HttpClientOptions getHttpClientOptions() {
        return new HttpClientOptions().setDefaultPort(8080);
    }

    public void tearDown() throws Exception {
        CountDownLatch latch;
        if (this.client != null) {
            latch = new CountDownLatch(1);
            this.client.close(asyncResult -> {
                this.assertTrue(asyncResult.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        if (this.server != null) {
            latch = new CountDownLatch(1);
            this.server.close(asyncResult -> {
                this.assertTrue(asyncResult.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        super.tearDown();
    }

    protected void testRequest(RequestOptions requestOptions, HttpResponseStatus statusCode) throws Exception {
        this.testRequest(requestOptions, null, statusCode.code(), statusCode.reasonPhrase(), null);
    }

    protected void testRequest(HttpMethod method, String path, HttpResponseStatus statusCode) throws Exception {
        this.testRequest(method, path, null, statusCode.code(), statusCode.reasonPhrase(), null);
    }

    protected void testRequest(RequestOptions requestOptions, int statusCode, String statusMessage) throws Exception {
        this.testRequest(requestOptions, null, statusCode, statusMessage, null);
    }

    protected void testRequest(HttpMethod method, String path, int statusCode, String statusMessage) throws Exception {
        this.testRequest(method, path, null, statusCode, statusMessage, null);
    }

    protected void testRequest(RequestOptions requestOptions, int statusCode, String statusMessage, String responseBody) throws Exception {
        this.testRequest(requestOptions, null, statusCode, statusMessage, responseBody);
    }

    protected void testRequest(HttpMethod method, String path, int statusCode, String statusMessage, String responseBody) throws Exception {
        this.testRequest(method, path, null, statusCode, statusMessage, responseBody);
    }

    protected void testRequest(RequestOptions requestOptions, int statusCode, String statusMessage, Buffer responseBody) throws Exception {
        this.testRequestBuffer(requestOptions, null, null, statusCode, statusMessage, responseBody);
    }

    protected void testRequest(HttpMethod method, String path, int statusCode, String statusMessage, Buffer responseBody) throws Exception {
        this.testRequestBuffer(method, path, null, null, statusCode, statusMessage, responseBody);
    }

    protected void testRequestWithContentType(RequestOptions requestOptions, String contentType, int statusCode, String statusMessage) throws Exception {
        this.testRequest(requestOptions, (HttpClientRequest req) -> req.putHeader("content-type", contentType), statusCode, statusMessage, null);
    }

    protected void testRequestWithContentType(HttpMethod method, String path, String contentType, int statusCode, String statusMessage) throws Exception {
        this.testRequest(method, path, (HttpClientRequest req) -> req.putHeader("content-type", contentType), statusCode, statusMessage, null);
    }

    protected void testRequestWithAccepts(RequestOptions requestOptions, String accepts, int statusCode, String statusMessage) throws Exception {
        this.testRequest(requestOptions, (HttpClientRequest req) -> req.putHeader("accept", accepts), statusCode, statusMessage, null);
    }

    protected void testRequestWithAccepts(HttpMethod method, String path, String accepts, int statusCode, String statusMessage) throws Exception {
        this.testRequest(method, path, (HttpClientRequest req) -> req.putHeader("accept", accepts), statusCode, statusMessage, null);
    }

    protected void testRequestWithCookies(RequestOptions requestOptions, String cookieHeader, int statusCode, String statusMessage) throws Exception {
        this.testRequest(requestOptions, (HttpClientRequest req) -> req.putHeader("cookie", cookieHeader), statusCode, statusMessage, null);
    }

    protected void testRequestWithCookies(HttpMethod method, String path, String cookieHeader, int statusCode, String statusMessage) throws Exception {
        this.testRequest(method, path, (HttpClientRequest req) -> req.putHeader("cookie", cookieHeader), statusCode, statusMessage, null);
    }

    protected void testRequest(RequestOptions requestOptions, Consumer<HttpClientRequest> requestAction, int statusCode, String statusMessage, String responseBody) throws Exception {
        this.testRequest(requestOptions, requestAction, null, statusCode, statusMessage, responseBody);
    }

    protected void testRequest(HttpMethod method, String path, Consumer<HttpClientRequest> requestAction, int statusCode, String statusMessage, String responseBody) throws Exception {
        this.testRequest(method, path, requestAction, null, statusCode, statusMessage, responseBody);
    }

    protected void testRequest(RequestOptions requestOptions, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, String responseBody) throws Exception {
        this.testRequestBuffer(requestOptions, requestAction, responseAction, statusCode, statusMessage, responseBody != null ? Buffer.buffer((String)responseBody) : null, true);
    }

    protected void testRequest(HttpMethod method, String path, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, String responseBody) throws Exception {
        this.testRequestBuffer(method, path, requestAction, responseAction, statusCode, statusMessage, responseBody != null ? Buffer.buffer((String)responseBody) : null, true);
    }

    protected void testRequestBuffer(RequestOptions requestOptions, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer) throws Exception {
        this.testRequestBuffer(requestOptions, requestAction, responseAction, statusCode, statusMessage, responseBodyBuffer, false);
    }

    protected void testRequestBuffer(HttpMethod method, String path, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer) throws Exception {
        this.testRequestBuffer(method, path, requestAction, responseAction, statusCode, statusMessage, responseBodyBuffer, false);
    }

    protected void testRequestBuffer(RequestOptions requestOptions, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer, boolean normalizeLineEndings) throws Exception {
        this.testRequestBuffer(this.client, requestOptions, requestAction, responseAction, statusCode, statusMessage, responseBodyBuffer, normalizeLineEndings);
    }

    protected void testRequestBuffer(HttpMethod method, String path, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer, boolean normalizeLineEndings) throws Exception {
        this.testRequestBuffer(this.client, method, 8080, path, requestAction, responseAction, statusCode, statusMessage, responseBodyBuffer, normalizeLineEndings);
    }

    protected void testRequestBuffer(HttpClient client, RequestOptions requestOptions, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer) throws Exception {
        this.testRequestBuffer(client, requestOptions, requestAction, responseAction, statusCode, statusMessage, responseBodyBuffer, false);
    }

    protected void testRequestBuffer(HttpClient client, HttpMethod method, int port, String path, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer) throws Exception {
        this.testRequestBuffer(client, method, port, path, requestAction, responseAction, statusCode, statusMessage, responseBodyBuffer, false);
    }

    protected void testRequestBuffer(HttpClient client, HttpMethod method, int port, String path, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer, boolean normalizeLineEndings) throws Exception {
        this.testRequestBuffer(client, new RequestOptions().setMethod(method).setPort(Integer.valueOf(port)).setURI(path).setHost("localhost"), requestAction, responseAction, statusCode, statusMessage, responseBodyBuffer, normalizeLineEndings);
    }

    protected void testRequestBuffer(HttpClient client, RequestOptions requestOptions, Consumer<HttpClientRequest> requestAction, Consumer<HttpClientResponse> responseAction, int statusCode, String statusMessage, Buffer responseBodyBuffer, boolean normalizeLineEndings) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        client.request(requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> {
                this.assertEquals(statusCode, resp.statusCode());
                this.assertEquals(statusMessage, resp.statusMessage());
                if (responseAction != null) {
                    responseAction.accept((HttpClientResponse)resp);
                }
                if (responseBodyBuffer == null) {
                    latch.countDown();
                } else {
                    resp.bodyHandler(buff -> {
                        if (normalizeLineEndings) {
                            buff = WebTestBase.normalizeLineEndingsFor(buff);
                        }
                        this.assertEquals(responseBodyBuffer, buff);
                        latch.countDown();
                    });
                }
            }));
            if (requestAction != null) {
                requestAction.accept((HttpClientRequest)req);
            }
            req.end();
        }));
        this.awaitLatch(latch);
    }

    protected static Buffer normalizeLineEndingsFor(Buffer buff) {
        int buffLen = buff.length();
        Buffer normalized = Buffer.buffer((int)buffLen);
        for (int i = 0; i < buffLen; ++i) {
            short unsignedByte = buff.getUnsignedByte(i);
            if (unsignedByte == 13 && i + 1 != buffLen && buff.getUnsignedByte(i + 1) == 10) continue;
            normalized.appendUnsignedByte(unsignedByte);
        }
        return normalized;
    }

    protected void testSyncRequest(String httpMethod, String path, int statusCode, String statusMessage, String responseBody) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL("http://localhost:" + this.server.actualPort() + path).openConnection();
        connection.setRequestMethod(httpMethod);
        this.assertEquals(statusCode, connection.getResponseCode());
        if (connection.getResponseCode() < 400) {
            String inputLine;
            this.assertEquals(statusMessage, connection.getResponseMessage());
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            this.assertEquals(responseBody, response.toString());
        } else {
            String inputLine;
            this.assertEquals(statusMessage, connection.getResponseMessage());
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            this.assertEquals(responseBody, response.toString());
        }
    }
}

