/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.auth.properties.PropertyFileAuthorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import org.junit.AfterClass;
import org.junit.Test;

public abstract class AuthHandlerTestBase
extends WebTestBase {
    @AfterClass
    public static void oneTimeTearDown() {
        Vertx vertx = Vertx.vertx();
        if (vertx.fileSystem().existsBlocking("file-uploads")) {
            vertx.fileSystem().deleteRecursiveBlocking("file-uploads", true);
        }
    }

    @Test
    public void testAuthAuthorities() throws Exception {
        this.testAuthorization("tim", false, (Authorization)PermissionBasedAuthorization.create((String)"dance"));
    }

    @Test
    public void testAuthAuthoritiesFail() throws Exception {
        this.testAuthorization("tim", true, (Authorization)PermissionBasedAuthorization.create((String)"knitter"));
    }

    protected abstract AuthenticationHandler createAuthHandler(AuthenticationProvider var1);

    protected boolean requiresSession() {
        return false;
    }

    protected SessionStore getSessionStore() {
        return LocalSessionStore.create((Vertx)this.vertx);
    }

    protected void testAuthorization(String username, boolean fail, Authorization authority) throws Exception {
        if (this.requiresSession()) {
            this.router.route().handler((Handler)BodyHandler.create());
            SessionStore store = this.getSessionStore();
            this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        }
        PropertyFileAuthentication authNProvider = PropertyFileAuthentication.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        PropertyFileAuthorization authZProvider = PropertyFileAuthorization.create((Vertx)this.vertx, (String)"login/loginusers.properties");
        AuthenticationHandler authNHandler = this.createAuthHandler((AuthenticationProvider)authNProvider);
        this.router.route().handler(arg_0 -> AuthHandlerTestBase.lambda$testAuthorization$1(username, (AuthenticationProvider)authNProvider, arg_0));
        this.router.route().handler((Handler)authNHandler);
        if (authority != null) {
            this.router.route().handler((Handler)AuthorizationHandler.create((Authorization)authority).addAuthorizationProvider((AuthorizationProvider)authZProvider));
        }
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", fail ? 403 : 200, fail ? "Forbidden" : "OK");
    }

    private static /* synthetic */ void lambda$testAuthorization$1(String username, AuthenticationProvider authNProvider, RoutingContext rc) {
        if (rc.user() == null) {
            UsernamePasswordCredentials authInfo = new UsernamePasswordCredentials(username, "delicious:sausages");
            authNProvider.authenticate((Credentials)authInfo, res -> {
                if (res.succeeded()) {
                    rc.setUser((User)res.result());
                    rc.next();
                } else {
                    rc.fail(res.cause());
                }
            });
        }
    }
}

