/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import org.junit.Test;

public class ChainAuthMixHandlerTest
extends WebTestBase {
    private final AuthenticationHandler success = new AuthenticationHandlerImpl((authInfo, resultHandler) -> resultHandler.handle((Object)Future.succeededFuture((Object)User.create((JsonObject)new JsonObject())))){

        public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
            handler.handle((Object)Future.succeededFuture(JsonObject::new));
        }
    };
    private final AuthenticationHandler failure = new AuthenticationHandlerImpl((authInfo, resultHandler) -> resultHandler.handle((Object)Future.failedFuture((String)"Oops!"))){

        public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
            handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(401)));
        }
    };

    @Test
    public void testFailOrFailOrSuccess() throws Exception {
        ChainAuthHandler chain = ChainAuthHandler.any().add(this.failure).add((AuthenticationHandler)ChainAuthHandler.any().add(this.failure).add(this.success));
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)chain);
        this.router.route().handler(ctx -> ctx.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testFailOrSuccessAndFail() throws Exception {
        ChainAuthHandler chain = ChainAuthHandler.any().add(this.failure).add((AuthenticationHandler)ChainAuthHandler.all().add(this.success).add(this.failure));
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)chain);
        this.router.route().handler(ctx -> ctx.response().end());
        this.testRequest(HttpMethod.GET, "/", 401, "Unauthorized");
    }
}

