/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.JWTAuthHandler;
import java.util.HashSet;
import org.junit.Before;
import org.junit.Test;

public class MultiAuthorizationHandlerTest
extends WebTestBase {
    JWTAuth authProvider;

    @Before
    public void setup() throws Exception {
        this.authProvider = JWTAuth.create((Vertx)this.vertx, (JWTAuthOptions)new JWTAuthOptions().setKeyStore(new KeyStoreOptions().setType("jceks").setPath("keystore.jceks").setPassword("secret")));
    }

    @Test
    public void testJWTAuthenticationNoAuthorization() throws Exception {
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/page1").handler(rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("paulo", rc.user().attributes().getJsonObject("accessToken").getString("sub"));
            rc.response().end("Welcome");
        });
        this.testRequest(HttpMethod.GET, "/protected/page1", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(new JsonObject().put("sub", (Object)"paulo"), new JWTOptions())), 200, "OK", "Welcome");
    }

    @Test
    public void testJWTAuthenticationWithAuthorization1() throws Exception {
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/*").handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"role1")));
        this.router.route("/protected/page1").handler(rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("paulo", rc.user().attributes().getJsonObject("accessToken").getString("sub"));
            rc.response().end("Welcome");
        });
        this.testRequest(HttpMethod.GET, "/protected/page1", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(new JsonObject().put("sub", (Object)"paulo"), new JWTOptions())), 403, "Forbidden", "Forbidden");
    }

    @Test
    public void testJWTAuthenticationWithAuthorization2() throws Exception {
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/*").handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"role1")).addAuthorizationProvider(this.createProvider("authzProvider1", (Authorization)RoleBasedAuthorization.create((String)"role1"))));
        this.router.route("/protected/page1").handler(rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("paulo", rc.user().attributes().getJsonObject("accessToken").getString("sub"));
            rc.response().end("Welcome");
        });
        this.testRequest(HttpMethod.GET, "/protected/page1", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(new JsonObject().put("sub", (Object)"paulo"), new JWTOptions())), 200, "OK", "Welcome");
    }

    @Test
    public void testJWTAuthenticationWithAuthorization3() throws Exception {
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/*").handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"role3")).addAuthorizationProvider(this.createProvider("authzProvider1", (Authorization)RoleBasedAuthorization.create((String)"role1"))).addAuthorizationProvider(this.createProvider("authzProvider2", (Authorization)RoleBasedAuthorization.create((String)"role2"))).addAuthorizationProvider(this.createProvider("authzProvider3", (Authorization)RoleBasedAuthorization.create((String)"role3"))));
        this.router.route("/protected/page1").handler(rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("paulo", rc.user().attributes().getJsonObject("accessToken").getString("sub"));
            rc.response().end("Welcome");
        });
        this.testRequest(HttpMethod.GET, "/protected/page1", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(new JsonObject().put("sub", (Object)"paulo"), new JWTOptions())), 200, "OK", "Welcome");
    }

    @Test
    public void testJWTAuthenticationWithAuthorization4() throws Exception {
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/*").handler((Handler)AuthorizationHandler.create((Authorization)RoleBasedAuthorization.create((String)"role4")).addAuthorizationProvider(this.createProvider("authzProvider1", (Authorization)RoleBasedAuthorization.create((String)"role1"))).addAuthorizationProvider(this.createProvider("authzProvider2", (Authorization)RoleBasedAuthorization.create((String)"role2"))).addAuthorizationProvider(this.createProvider("authzProvider3", (Authorization)RoleBasedAuthorization.create((String)"role3"))));
        this.router.route("/protected/page1").handler(rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("paulo", rc.user().attributes().getJsonObject("accessToken").getString("sub"));
            rc.response().end("Welcome");
        });
        this.testRequest(HttpMethod.GET, "/protected/page1", (HttpClientRequest req) -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(new JsonObject().put("sub", (Object)"paulo"), new JWTOptions())), 403, "Forbidden", "Forbidden");
    }

    private AuthorizationProvider createProvider(final String id, Authorization authorization) {
        final HashSet<Authorization> _authorizations = new HashSet<Authorization>();
        _authorizations.add(authorization);
        return new AuthorizationProvider(){

            public String getId() {
                return id;
            }

            public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
                user.authorizations().add(this.getId(), _authorizations);
                handler.handle((Object)Future.succeededFuture());
            }
        };
    }
}

