/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import org.junit.AfterClass;
import org.junit.Test;

public class RerouteTest
extends WebTestBase {
    @AfterClass
    public static void oneTimeTearDown() {
        Vertx vertx = Vertx.vertx();
        if (vertx.fileSystem().existsBlocking("file-uploads")) {
            vertx.fileSystem().deleteRecursiveBlocking("file-uploads", true);
        }
    }

    @Test
    public void testReroute() throws Exception {
        this.router.get("/users/:name").handler(ctx -> ctx.response().end("/users/:name"));
        this.router.get("/me").handler(ctx -> ctx.reroute("/users/paulo"));
        this.testRequest(HttpMethod.GET, "/me", 200, "OK", "/users/:name");
    }

    @Test
    public void testRerouteReparse() throws Exception {
        this.router.get("/users/:name").handler(ctx -> ctx.response().end(ctx.request().getParam("name")));
        this.router.get("/me").handler(ctx -> ctx.reroute("/users/paulo"));
        this.testRequest(HttpMethod.GET, "/me", 200, "OK", "paulo");
    }

    @Test
    public void testRerouteMethod() throws Exception {
        this.router.post("/me").handler(ctx -> ctx.response().end("POST"));
        this.router.get("/me").handler(ctx -> ctx.reroute(HttpMethod.POST, "/me"));
        this.testRequest(HttpMethod.GET, "/me", 200, "OK", "POST");
    }

    @Test
    public void testRerouteWithBody() throws Exception {
        this.router.route("/test/*").handler((Handler)BodyHandler.create());
        this.router.route("/test/v1").handler(ctx -> ctx.reroute("/test/v2"));
        this.router.route("/test/v2").handler(ctx -> ctx.response().end());
        this.testRequest(HttpMethod.POST, "/test/v1", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write("Test HTTP Body");
        }, 200, "OK", null);
    }

    @Test
    public void testRerouteFailure() throws Exception {
        this.router.get("/error/400").handler(ctx -> ctx.response().setStatusCode(400).end("/error/400"));
        this.router.get("/me").handler(ctx -> ctx.fail(400));
        this.router.get().failureHandler(ctx -> {
            if (ctx.statusCode() == 400) {
                ctx.reroute("/error/400");
            } else {
                ctx.next();
            }
        });
        this.testRequest(HttpMethod.GET, "/me", 400, "Bad Request", "/error/400");
    }

    @Test
    public void testRerouteClearHeader() throws Exception {
        this.router.get("/users/:name").handler(ctx -> ctx.response().end("/users/:name"));
        this.router.get("/me").handler(ctx -> {
            ctx.response().putHeader("X-woop", "durp");
            ctx.reroute("/users/paulo");
        });
        this.testRequest(HttpMethod.GET, "/me", null, res -> this.assertNull(res.getHeader("X-woop")), 200, "OK", "/users/:name");
    }

    @Test
    public void testRerouteClearHeader2() throws Exception {
        this.router.get("/users/:name").handler(ctx -> {
            ctx.response().putHeader("X-woop", "durp2");
            ctx.response().end("/users/:name");
        });
        this.router.get("/me").handler(ctx -> {
            ctx.response().putHeader("X-woop", "durp");
            ctx.reroute("/users/paulo");
        });
        this.testRequest(HttpMethod.GET, "/me", null, res -> this.assertEquals("durp2", res.getHeader("X-woop")), 200, "OK", "/users/:name");
    }

    @Test
    public void testRerouteClearHeader3() throws Exception {
        this.router.get("/users/:name").handler(ctx -> {
            ctx.response().putHeader("X-woop", "durp2");
            ctx.response().end("/users/:name");
        });
        this.router.get("/me").handler(ctx -> {
            ctx.response().putHeader("X-woop", "durp");
            ctx.reroute("/users/paulo");
        });
        this.testRequest(HttpMethod.GET, "/me", null, res -> {
            this.assertEquals("durp2", res.getHeader("X-woop"));
            this.assertNull(res.getHeader("Cookie"));
        }, 200, "OK", "/users/:name");
    }

    @Test
    public void testRerouteWithParams() throws Exception {
        this.router.get("/other").handler(ctx -> ctx.response().end("/other"));
        this.router.get("/base").handler(ctx -> ctx.reroute("/other?paramter1=p1&parameter2=p2"));
        this.testRequest(HttpMethod.GET, "/base", 200, "OK", "/other");
    }

    @Test
    public void testRerouteAbsoluteURI() throws Exception {
        this.router.get("/other").handler(ctx -> {
            this.assertEquals("http://localhost:8080/other?paramter1=p1&parameter2=p2", ctx.request().absoluteURI());
            this.assertEquals("p1", ctx.queryParam("paramter1").get(0));
            this.assertEquals("p2", ctx.queryParam("parameter2").get(0));
            ctx.response().end("/other");
        });
        this.router.get("/base").handler(ctx -> ctx.reroute("/other?paramter1=p1&parameter2=p2"));
        this.testRequest(HttpMethod.GET, "/base?p=1", 200, "OK", "/other");
    }

    @Test
    public void testRerouteChecksWithQuery() throws Exception {
        this.router.get("/other").handler(ctx -> {
            HttpServerRequest req = ctx.request();
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("GET", req.method().name());
            this.assertEquals("/other", req.path());
            this.assertEquals("paramter1=p1&parameter2=p2", req.query());
            this.assertEquals("/other?paramter1=p1&parameter2=p2", req.uri());
            this.assertEquals("http://localhost:8080/other?paramter1=p1&parameter2=p2", req.absoluteURI());
            this.assertEquals("p1", ctx.queryParam("paramter1").get(0));
            this.assertEquals("p2", ctx.queryParam("parameter2").get(0));
            ctx.response().end("/other");
        });
        this.router.get("/base").handler(ctx -> {
            HttpServerRequest req = ctx.request();
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("GET", req.method().name());
            this.assertEquals("/base", req.path());
            this.assertEquals("p=1", req.query());
            this.assertEquals("/base?p=1", req.uri());
            this.assertEquals("http://localhost:8080/base?p=1", req.absoluteURI());
            ctx.reroute("/other?paramter1=p1&parameter2=p2");
        });
        this.testRequest(HttpMethod.GET, "/base?p=1", 200, "OK", "/other");
    }

    @Test
    public void testRerouteChecksWithQueryAndFragment() throws Exception {
        this.router.get("/other").handler(ctx -> {
            HttpServerRequest req = ctx.request();
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("GET", req.method().name());
            this.assertEquals("/other", req.path());
            this.assertEquals("paramter1=p1&parameter2=p2", req.query());
            this.assertEquals("/other?paramter1=p1&parameter2=p2#frag", req.uri());
            this.assertEquals("http://localhost:8080/other?paramter1=p1&parameter2=p2#frag", req.absoluteURI());
            this.assertEquals("p1", ctx.queryParam("paramter1").get(0));
            this.assertEquals("p2", ctx.queryParam("parameter2").get(0));
            ctx.response().end("/other");
        });
        this.router.get("/base").handler(ctx -> {
            HttpServerRequest req = ctx.request();
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("GET", req.method().name());
            this.assertEquals("/base", req.path());
            this.assertEquals("p=1", req.query());
            this.assertEquals("/base?p=1", req.uri());
            this.assertEquals("http://localhost:8080/base?p=1", req.absoluteURI());
            ctx.reroute("/other?paramter1=p1&parameter2=p2#frag");
        });
        this.testRequest(HttpMethod.GET, "/base?p=1", 200, "OK", "/other");
    }

    @Test
    public void testRerouteChecksWithFragment() throws Exception {
        this.router.get("/other").handler(ctx -> {
            HttpServerRequest req = ctx.request();
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("GET", req.method().name());
            this.assertEquals("/other", req.path());
            this.assertNull(req.query());
            this.assertEquals("/other#frag", req.uri());
            this.assertEquals("http://localhost:8080/other#frag", req.absoluteURI());
            ctx.response().end("/other");
        });
        this.router.get("/base").handler(ctx -> {
            HttpServerRequest req = ctx.request();
            this.assertEquals(HttpMethod.GET, req.method());
            this.assertEquals("GET", req.method().name());
            this.assertEquals("/base", req.path());
            this.assertEquals("p=1", req.query());
            this.assertEquals("/base?p=1", req.uri());
            this.assertEquals("http://localhost:8080/base?p=1", req.absoluteURI());
            ctx.reroute("/other#frag");
        });
        this.testRequest(HttpMethod.GET, "/base?p=1", 200, "OK", "/other");
    }

    @Test
    public void testRerouteWhenBaseRequestHasBadlyEncodedParams() throws Exception {
        this.router.get("/other").handler(ctx -> {
            this.assertEquals(true, ctx.request().params().isEmpty());
            ctx.response().end("/other");
        });
        this.router.get("/base").handler(ctx -> ctx.reroute("/other"));
        this.testRequest(HttpMethod.GET, "/base?parameter1=%%value1%%", 200, "OK", "/other");
    }
}

