/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Collections;
import org.junit.AfterClass;
import org.junit.Test;

public class RoutingContextImplTest
extends WebTestBase {
    @AfterClass
    public static void oneTimeTearDown() {
        Vertx vertx = Vertx.vertx();
        if (vertx.fileSystem().existsBlocking("file-uploads")) {
            vertx.fileSystem().deleteRecursiveBlocking("file-uploads", true);
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.router.route().handler((Handler)BodyHandler.create());
    }

    @Test
    public void test_empty_array_as_json_array_yields_empty_json_array() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(new JsonArray(), event.getBodyAsJsonArray());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"[]"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void test_empty_yields_null_json_types() throws Exception {
        this.router.route().handler(event -> {
            this.assertNull(event.getBodyAsJsonArray());
            this.assertNull(event.getBodyAsJson());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)""));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void test_one_item_array_as_json_array_yields_one_item_json_array() throws Exception {
        this.router.route().handler(event -> {
            JsonArray array = new JsonArray(Collections.singletonList(new JsonObject(Collections.singletonMap("foo", "bar"))));
            this.assertEquals(array, event.getBodyAsJsonArray());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"[ { \"foo\": \"bar\" } ]"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void test_null_literal_array_as_json_array_yields_null_json_array() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(null, event.getBodyAsJsonArray());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"null"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void test_non_array_as_json_array_fails_json_array() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(null, event.getBodyAsJsonArray());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"\"1234"));
        }, HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), HttpResponseStatus.INTERNAL_SERVER_ERROR.reasonPhrase(), null);
    }

    @Test
    public void test_invalid_array_as_json_array_fails_json_array() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(null, event.getBodyAsJsonArray());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"1234"));
        }, HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), HttpResponseStatus.INTERNAL_SERVER_ERROR.reasonPhrase(), null);
    }

    @Test
    public void test_empty_object_as_json_yields_empty_json_object() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(new JsonObject(), event.getBodyAsJson());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"{ }"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void test_object_as_json_yields_json_object() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(new JsonObject(Collections.singletonMap("foo", "bar")), event.getBodyAsJson());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"{ \"foo\": \"bar\" }"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void test_null_literal_object_as_json_yields_empty_json_object() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(null, event.getBodyAsJson());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"null"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void test_invalid_json_object_as_json_fails_json_object() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(null, event.getBodyAsJson());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"\"1234"));
        }, HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), HttpResponseStatus.INTERNAL_SERVER_ERROR.reasonPhrase(), null);
    }

    @Test
    public void test_non_json_object_as_json_fails_json_object() throws Exception {
        this.router.route().handler(event -> {
            this.assertEquals(null, event.getBodyAsJson());
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"1234"));
        }, HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), HttpResponseStatus.INTERNAL_SERVER_ERROR.reasonPhrase(), null);
    }

    @Test
    public void test_remove_data() throws Exception {
        this.router.route().handler(event -> {
            String foo = event.getBodyAsJson().encode();
            event.put("foo", (Object)foo);
            String removedFoo = (String)event.remove("foo");
            this.assertEquals(removedFoo, foo);
            this.assertNull(event.get("foo"));
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.write((Object)Buffer.buffer((String)"{ \"foo\": \"bar\" }"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void testAttachment() throws Exception {
        this.router.route().handler(event -> event.attachment("myfile.pdf").response().end("PDF"));
        this.testRequest(HttpMethod.GET, "/", null, res -> {
            this.assertEquals("attachment; filename=myfile.pdf", res.getHeader("Content-Disposition"));
            this.assertEquals("application/pdf", res.getHeader("Content-Type"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void testAttachmentWithoutMIME() throws Exception {
        this.router.route().handler(event -> event.attachment("myfile.paulo").response().end("PDF"));
        this.testRequest(HttpMethod.GET, "/", null, res -> {
            this.assertEquals("attachment; filename=myfile.paulo", res.getHeader("Content-Disposition"));
            this.assertNull(res.getHeader("Content-Type"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void testJsonObject() throws Exception {
        this.router.route().handler(ctx -> ctx.json((Object)new JsonObject()));
        this.testRequest(HttpMethod.GET, "/", null, res -> this.assertEquals("application/json; charset=utf-8", res.getHeader("Content-Type")), HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void testJsonArray() throws Exception {
        this.router.route().handler(ctx -> ctx.json((Object)new JsonArray()));
        this.testRequest(HttpMethod.GET, "/", null, res -> this.assertEquals("application/json; charset=utf-8", res.getHeader("Content-Type")), HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void testJsonPrimitive() throws Exception {
        this.router.route().handler(ctx -> ctx.json((Object)true));
        this.testRequest(HttpMethod.GET, "/", null, res -> this.assertEquals("application/json; charset=utf-8", res.getHeader("Content-Type")), HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), "true");
    }

    @Test
    public void testJsonNull() throws Exception {
        this.router.route().handler(ctx -> ctx.json(null));
        this.testRequest(HttpMethod.GET, "/", null, res -> this.assertEquals("application/json; charset=utf-8", res.getHeader("Content-Type")), HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), "null");
    }

    @Test
    public void testIs() throws Exception {
        this.router.route().handler(event -> {
            this.assertTrue(event.is("json"));
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.putHeader("Content-Type", "application/json");
            req.write((Object)Buffer.buffer((String)"{ \"foo\": \"bar\" }"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void testIs2() throws Exception {
        this.router.route().handler(event -> {
            this.assertTrue(event.is("application/json"));
            event.response().end();
        });
        this.testRequest(HttpMethod.POST, "/", (HttpClientRequest req) -> {
            req.setChunked(true);
            req.putHeader("Content-Type", "application/json");
            req.write((Object)Buffer.buffer((String)"{ \"foo\": \"bar\" }"));
        }, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }

    @Test
    public void testSessionAccessed() throws Exception {
        this.router.route().handler(event -> {
            this.assertFalse(event.isSessionAccessed());
            event.session();
            this.assertTrue(event.isSessionAccessed());
            event.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", null, HttpResponseStatus.OK.code(), HttpResponseStatus.OK.reasonPhrase(), null);
    }
}

