/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.handler.TemplateHandler;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.junit.Test;

public class TemplateTest
extends WebTestBase {
    @Test
    public void testTemplateHandler() throws Exception {
        this.testRelativeToRoutePath(null);
    }

    @Test
    public void testTemplateHandler2() throws Exception {
        this.testRelativeToRoutePath("/");
    }

    @Test
    public void testRelativeToRoutePath() throws Exception {
        this.testRelativeToRoutePath("/pathprefix/");
    }

    private void testRelativeToRoutePath(String pathPrefix) throws Exception {
        TestEngine engine = new TestEngine(false);
        this.router.route().handler(context -> {
            context.put("foo", (Object)"badger");
            context.put("bar", (Object)"fox");
            context.next();
        });
        Route route = this.router.route();
        if (pathPrefix != null) {
            route.path(pathPrefix + "*");
        }
        route.handler((Handler)TemplateHandler.create((TemplateEngine)engine, (String)"somedir", (String)"text/html"));
        String expected = "<html>\n<body>\n<h1>Test template</h1>\nfoo is badger bar is fox<br>\n</body>\n</html>";
        this.testRequest(HttpMethod.GET, pathPrefix != null ? pathPrefix + "/test-template.html" : "/test-template.html", 200, "OK", expected);
    }

    @Test
    public void testTemplateEngineFail() throws Exception {
        TestEngine engine = new TestEngine(true);
        this.router.route().handler((Handler)TemplateHandler.create((TemplateEngine)engine, (String)"somedir", (String)"text/html"));
        this.router.errorHandler(500, ctx -> {
            Throwable t = ctx.failure();
            this.assertEquals("eek", t.getMessage());
            this.testComplete();
        });
        this.testRequest(HttpMethod.GET, "/foo.html", 500, "Internal Server Error");
        this.await();
    }

    @Test
    public void testTemplateEngineWithPathVariables() throws Exception {
        TestEngine engine = new TestEngine(false);
        this.router.route().handler(context -> {
            context.put("foo", (Object)"badger");
            context.put("bar", (Object)"fox");
            context.next();
        });
        this.router.route("/:project/*").handler((Handler)TemplateHandler.create((TemplateEngine)engine, (String)"somedir", (String)"text/html"));
        String expected = "<html>\n<body>\n<h1>Test template</h1>\nfoo is badger bar is fox<br>\n</body>\n</html>";
        this.testRequest(HttpMethod.GET, "/1/test-template.html", 200, "OK", expected);
    }

    @Test
    public void testRenderDirectly() throws Exception {
        TestEngine engine = new TestEngine(false);
        this.router.route().handler(context -> {
            context.put("foo", (Object)"badger");
            context.put("bar", (Object)"fox");
            engine.render(context.data(), "somedir/test-template.html", res -> {
                if (res.succeeded()) {
                    context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html").end((Buffer)res.result());
                } else {
                    context.fail(res.cause());
                }
            });
        });
        String expected = "<html>\n<body>\n<h1>Test template</h1>\nfoo is badger bar is fox<br>\n</body>\n</html>";
        this.testRequest(HttpMethod.GET, "/", 200, "OK", expected);
    }

    @Test
    public void testRenderToBuffer() throws Exception {
        TestEngine engine = new TestEngine(false);
        String expected = "<html>\n<body>\n<h1>Test template</h1>\nfoo is badger bar is fox<br>\n</body>\n</html>";
        this.router.route().handler(context -> {
            context.put("foo", (Object)"badger");
            context.put("bar", (Object)"fox");
            engine.render(context.data(), "somedir/test-template.html", this.onSuccess(res -> {
                String rendered = res.toString();
                String actual = TemplateTest.normalizeLineEndingsFor(res).toString();
                this.assertEquals(expected, actual);
                context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
                context.response().end(rendered);
                this.testComplete();
            }));
        });
        this.testRequestBuffer(HttpMethod.GET, "/", null, null, 200, "OK", Buffer.buffer((String)expected), true);
        this.await();
    }

    class TestEngine
    implements TemplateEngine {
        boolean fail;

        TestEngine(boolean fail) {
            this.fail = fail;
        }

        public void render(Map<String, Object> context, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
            if (this.fail) {
                handler.handle((Object)Future.failedFuture((Throwable)new Exception("eek")));
            } else {
                String templ = TemplateTest.this.vertx.fileSystem().readFileBlocking(templateFileName).toString(StandardCharsets.UTF_8);
                String rendered = templ.replace("{foo}", (String)context.get("foo"));
                rendered = rendered.replace("{bar}", (String)context.get("bar"));
                handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)rendered)));
            }
        }
    }
}

