/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.handlebars.impl;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.handler.impl.TemplateHandlerImpl;
import org.junit.Test;
import org.mockito.Mockito;

public class TemplateHandlerImplTest {
    @Test
    public void testDefaultIndex() {
        TemplateEngine templateEngine = (TemplateEngine)Mockito.mock(TemplateEngine.class);
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.normalizedPath()).thenReturn((Object)"/");
        Route currentRoute = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)currentRoute.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn((Object)currentRoute);
        TemplateHandlerImpl templateHandler = new TemplateHandlerImpl(templateEngine, "templates", "ext");
        templateHandler.handle((Object)routingContext);
        ((TemplateEngine)Mockito.verify((Object)templateEngine)).render((JsonObject)Mockito.any(JsonObject.class), (String)Mockito.eq((Object)"templates/index"), (Handler)Mockito.any());
    }

    @Test
    public void testSetIndex() {
        TemplateEngine templateEngine = (TemplateEngine)Mockito.mock(TemplateEngine.class);
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.normalizedPath()).thenReturn((Object)"/");
        Route currentRoute = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)currentRoute.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn((Object)currentRoute);
        TemplateHandlerImpl templateHandler = new TemplateHandlerImpl(templateEngine, "templates", "ext");
        templateHandler.setIndexTemplate("home");
        templateHandler.handle((Object)routingContext);
        ((TemplateEngine)Mockito.verify((Object)templateEngine)).render((JsonObject)Mockito.any(JsonObject.class), (String)Mockito.eq((Object)"templates/home"), (Handler)Mockito.any());
    }

    @Test
    public void testTurnOffIndex() {
        TemplateEngine templateEngine = (TemplateEngine)Mockito.mock(TemplateEngine.class);
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.normalizedPath()).thenReturn((Object)"/");
        Route currentRoute = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)currentRoute.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn((Object)currentRoute);
        TemplateHandlerImpl templateHandler = new TemplateHandlerImpl(templateEngine, "templates", "ext");
        templateHandler.setIndexTemplate(null);
        templateHandler.handle((Object)routingContext);
        ((TemplateEngine)Mockito.verify((Object)templateEngine)).render((JsonObject)Mockito.any(JsonObject.class), (String)Mockito.eq((Object)"templates/"), (Handler)Mockito.any());
    }

    @Test
    public void testSimpleTemplate() {
        TemplateEngine templateEngine = (TemplateEngine)Mockito.mock(TemplateEngine.class);
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.normalizedPath()).thenReturn((Object)"/about");
        Route currentRoute = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)currentRoute.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn((Object)currentRoute);
        TemplateHandlerImpl templateHandler = new TemplateHandlerImpl(templateEngine, "templates", "ext");
        templateHandler.handle((Object)routingContext);
        ((TemplateEngine)Mockito.verify((Object)templateEngine)).render((JsonObject)Mockito.any(JsonObject.class), (String)Mockito.eq((Object)"templates/about"), (Handler)Mockito.any());
    }
}

