/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.zookeeper.impl.ZKMap;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.zookeeper.data.Stat;

public class ZKAsyncMap<K, V>
extends ZKMap<K, V>
implements AsyncMap<K, V> {
    public ZKAsyncMap(Vertx vertx, CuratorFramework curator, String mapName) {
        super(curator, vertx, "asyncMap", mapName);
    }

    public Future<V> get(K k) {
        return this.assertKeyIsNotNull(k).compose(aVoid -> this.checkExists(k)).compose(checkResult -> {
            Promise promise = Promise.promise();
            if (checkResult.booleanValue()) {
                try {
                    ((ErrorListenerPathable)this.curator.getData().inBackground((c, e) -> {
                        if (e.getType() == CuratorEventType.GET_DATA) {
                            Object value = this.asObject(e.getData());
                            this.vertx.runOnContext(aVoid -> promise.complete(value));
                        }
                    })).forPath(this.keyPath(k));
                }
                catch (Exception e2) {
                    promise.fail((Throwable)e2);
                }
            } else {
                promise.complete();
            }
            return promise.future();
        });
    }

    public Future<Void> put(K k, V v) {
        return this.put(k, v, Optional.empty());
    }

    public Future<Void> put(K k, V v, long ttl) {
        return this.put(k, v, Optional.of(ttl));
    }

    private Future<Void> put(K k, V v, Optional<Long> timeoutOptional) {
        return this.assertKeyAndValueAreNotNull(k, v).compose(aVoid -> this.checkExists(k)).compose(checkResult -> checkResult != false ? this.setData(k, v) : this.create(k, v, timeoutOptional)).compose(stat -> Future.succeededFuture());
    }

    public Future<V> putIfAbsent(K k, V v) {
        return this.putIfAbsent(k, v, Optional.empty());
    }

    public Future<V> putIfAbsent(K k, V v, long ttl) {
        return this.putIfAbsent(k, v, Optional.of(ttl));
    }

    private Future<V> putIfAbsent(K k, V v, Optional<Long> timeoutOptional) {
        return this.assertKeyAndValueAreNotNull(k, v).compose(aVoid -> this.get(k)).compose(value -> {
            if (value == null) {
                if (timeoutOptional.isPresent()) {
                    return this.put(k, v, timeoutOptional).compose(aVoid -> Future.succeededFuture(null));
                }
                return this.put(k, v).compose(aVoid -> Future.succeededFuture(null));
            }
            return Future.succeededFuture((Object)value);
        });
    }

    public Future<V> remove(K k) {
        return this.assertKeyIsNotNull(k).compose(aVoid -> {
            Promise promise = Promise.promise();
            this.get(k, (Handler)promise);
            return promise.future();
        }).compose(value -> {
            Promise promise = Promise.promise();
            if (value != null) {
                return this.delete(k, value);
            }
            promise.complete();
            return promise.future();
        });
    }

    public Future<Boolean> removeIfPresent(K k, V v) {
        return this.assertKeyAndValueAreNotNull(k, v).compose(aVoid -> {
            Promise promise = Promise.promise();
            this.get(k, (Handler)promise);
            return promise.future();
        }).compose(value -> {
            Promise promise = Promise.promise();
            if (Objects.equals(value, v)) {
                this.delete(k, v).onComplete(deleteResult -> {
                    if (deleteResult.succeeded()) {
                        promise.complete((Object)true);
                    } else {
                        promise.fail(deleteResult.cause());
                    }
                });
            } else {
                promise.complete((Object)false);
            }
            return promise.future();
        });
    }

    public Future<V> replace(K k, V v) {
        return this.assertKeyAndValueAreNotNull(k, v).compose(aVoid -> {
            Promise innerPromise = Promise.promise();
            this.vertx.executeBlocking(future -> {
                long startTime = Instant.now().toEpochMilli();
                int retries = 0;
                try {
                    Object currentValue;
                    String path;
                    Stat stat;
                    do {
                        if ((currentValue = this.getData(stat = new Stat(), path = this.keyPath(k))) != null) continue;
                        future.complete(null);
                        return;
                    } while (!this.compareAndSet(startTime, retries++, stat, path, currentValue, v));
                    future.complete(currentValue);
                    return;
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                    return;
                }
            }, false, (Handler)innerPromise);
            return innerPromise.future();
        });
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        return this.assertKeyIsNotNull(k).compose(aVoid -> this.assertValueIsNotNull(oldValue)).compose(aVoid -> this.assertValueIsNotNull(newValue)).compose(aVoid -> {
            Promise innerPromise = Promise.promise();
            this.vertx.executeBlocking(future -> {
                long startTime = Instant.now().toEpochMilli();
                int retries = 0;
                try {
                    String path;
                    Stat stat;
                    do {
                        Object currentValue;
                        if ((currentValue = this.getData(stat = new Stat(), path = this.keyPath(k))).equals(oldValue)) continue;
                        future.complete((Object)false);
                        return;
                    } while (!this.compareAndSet(startTime, retries++, stat, path, oldValue, newValue));
                    future.complete((Object)true);
                    return;
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                    return;
                }
            }, false, (Handler)innerPromise);
            return innerPromise.future();
        });
    }

    public Future<Void> clear() {
        return this.delete(this.mapPath, null).mapEmpty();
    }

    public Future<Integer> size() {
        PromiseInternal promise = ((VertxInternal)this.vertx).getOrCreateContext().promise();
        try {
            ((ErrorListenerPathable)this.curator.getChildren().inBackground((arg_0, arg_1) -> ZKAsyncMap.lambda$size$22((Promise)promise, arg_0, arg_1))).forPath(this.mapPath);
        }
        catch (Exception e) {
            promise.tryFail((Throwable)e);
        }
        return promise.future();
    }

    public Future<Set<K>> keys() {
        PromiseInternal promise = ((VertxInternal)this.vertx).getOrCreateContext().promise();
        try {
            ((ErrorListenerPathable)this.curator.getChildren().inBackground((arg_0, arg_1) -> this.lambda$keys$23((Promise)promise, arg_0, arg_1))).forPath(this.mapPath);
        }
        catch (Exception e) {
            promise.tryFail((Throwable)e);
        }
        return promise.future();
    }

    public Future<List<V>> values() {
        PromiseInternal keysPromise = ((VertxInternal)this.vertx).getOrCreateContext().promise();
        this.keys((Handler)keysPromise);
        return keysPromise.future().compose(keys -> {
            ArrayList<Future> futures = new ArrayList<Future>(keys.size());
            for (Object k : keys) {
                Promise valuePromise = Promise.promise();
                this.get(k, (Handler)valuePromise);
                futures.add(valuePromise.future());
            }
            return CompositeFuture.all(futures).map(compositeFuture -> {
                ArrayList<Object> values = new ArrayList<Object>(compositeFuture.size());
                for (int i = 0; i < compositeFuture.size(); ++i) {
                    values.add(compositeFuture.resultAt(i));
                }
                return values;
            });
        });
    }

    public Future<Map<K, V>> entries() {
        PromiseInternal keysPromise = ((VertxInternal)this.vertx).getOrCreateContext().promise();
        this.keys((Handler)keysPromise);
        return keysPromise.future().map(ArrayList::new).compose(keys -> {
            ArrayList<Future> futures = new ArrayList<Future>(keys.size());
            for (Object k : keys) {
                Promise valuePromise = Promise.promise();
                this.get(k, (Handler)valuePromise);
                futures.add(valuePromise.future());
            }
            return CompositeFuture.all(futures).map(compositeFuture -> {
                HashMap map = new HashMap();
                for (int i = 0; i < compositeFuture.size(); ++i) {
                    map.put(keys.get(i), compositeFuture.resultAt(i));
                }
                return map;
            });
        });
    }

    @Override
    String keyPath(K k) {
        try {
            return this.keyPathPrefix() + Base64.getUrlEncoder().encodeToString(this.asByte(k));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String keyPathPrefix() {
        return this.mapPath + "/";
    }

    private /* synthetic */ void lambda$keys$23(Promise promise, CuratorFramework client, CuratorEvent event) throws Exception {
        HashSet keys = new HashSet();
        for (String base64Key : event.getChildren()) {
            Object key;
            byte[] binaryKey = Base64.getUrlDecoder().decode(base64Key);
            try {
                key = this.asObject(binaryKey);
            }
            catch (Exception e) {
                promise.tryFail((Throwable)e);
                return;
            }
            keys.add(key);
        }
        promise.tryComplete(keys);
    }

    private static /* synthetic */ void lambda$size$22(Promise promise, CuratorFramework client, CuratorEvent event) throws Exception {
        promise.tryComplete((Object)event.getChildren().size());
    }
}

