/*
 * Decompiled with CFR 0.152.
 */
package io.vigier.cursorpaging.jpa.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.vigier.cursorpaging.jpa.Attribute;
import io.vigier.cursorpaging.jpa.Filter;
import io.vigier.cursorpaging.jpa.Filters;
import io.vigier.cursorpaging.jpa.Order;
import io.vigier.cursorpaging.jpa.PageRequest;
import io.vigier.cursorpaging.jpa.QueryElement;
import io.vigier.cursorpaging.jpa.filter.FilterList;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DtoPageRequest {
    private Map<String, Order> orderBy;
    private final DtoFilterList filterBy;
    @Min(value=1L)
    @Max(value=100L)
    private @Min(value=1L) @Max(value=100L) int pageSize;
    private boolean withTotalCount;

    public static DtoPageRequest create(Consumer<DtoPageRequestBuilder> c) {
        DtoPageRequestBuilder builder = DtoPageRequest.builder();
        c.accept(builder);
        return builder.build();
    }

    public <T> PageRequest<T> toPageRequest(Function<String, Attribute> attributeProvider) {
        return PageRequest.create((T b) -> {
            this.orderBy.forEach((name, order) -> {
                Attribute attribute = (Attribute)attributeProvider.apply((String)name);
                switch (order) {
                    case ASC: {
                        b.asc(attribute);
                        break;
                    }
                    case DESC: {
                        b.desc(attribute);
                    }
                }
            });
            b.pageSize(this.pageSize).enableTotalCount(this.withTotalCount);
            b.filters((FilterList)this.filterOf(this.filterBy, attributeProvider));
        });
    }

    private QueryElement filterOf(DtoFilterElement f, Function<String, Attribute> attributeProvider) {
        if (f instanceof DtoFilter) {
            DtoFilter filter = (DtoFilter)f;
            Attribute attribute = attributeProvider.apply(filter.getAttribute());
            return filter.create(attribute, filter.getValues());
        }
        if (f instanceof DtoAndFilter) {
            DtoAndFilter list = (DtoAndFilter)f;
            return Filters.and(list.getFilters().stream().map(e -> this.filterOf((DtoFilterElement)e, attributeProvider)).toList());
        }
        if (f instanceof DtoOrFilter) {
            DtoOrFilter list = (DtoOrFilter)f;
            return Filters.or(list.getFilters().stream().map(e -> this.filterOf((DtoFilterElement)e, attributeProvider)).toList());
        }
        throw new IllegalStateException("Unknown filter element: " + (f != null ? f.getClass().getName() : "null"));
    }

    public void addOrderByIfAbsent(String name, Order order) {
        if (!this.orderBy.containsKey(name)) {
            this.orderBy.put(name, order);
        }
    }

    @Generated
    private static DtoFilterList $default$filterBy() {
        return new DtoAndFilter();
    }

    @Generated
    private static int $default$pageSize() {
        return 100;
    }

    @Generated
    public static DtoPageRequestBuilder builder() {
        return new DtoPageRequestBuilder();
    }

    @Generated
    public Map<String, Order> getOrderBy() {
        return this.orderBy;
    }

    @Generated
    public DtoFilterList getFilterBy() {
        return this.filterBy;
    }

    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    @Generated
    public boolean isWithTotalCount() {
        return this.withTotalCount;
    }

    @Generated
    public void setOrderBy(Map<String, Order> orderBy) {
        this.orderBy = orderBy;
    }

    @Generated
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setWithTotalCount(boolean withTotalCount) {
        this.withTotalCount = withTotalCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DtoPageRequest)) {
            return false;
        }
        DtoPageRequest other = (DtoPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.isWithTotalCount() != other.isWithTotalCount()) {
            return false;
        }
        Map<String, Order> this$orderBy = this.getOrderBy();
        Map<String, Order> other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy)) {
            return false;
        }
        DtoFilterList this$filterBy = this.getFilterBy();
        DtoFilterList other$filterBy = other.getFilterBy();
        return !(this$filterBy == null ? other$filterBy != null : !((Object)this$filterBy).equals(other$filterBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DtoPageRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        result = result * 59 + (this.isWithTotalCount() ? 79 : 97);
        Map<String, Order> $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        DtoFilterList $filterBy = this.getFilterBy();
        result = result * 59 + ($filterBy == null ? 43 : ((Object)$filterBy).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DtoPageRequest(orderBy=" + String.valueOf(this.getOrderBy()) + ", filterBy=" + String.valueOf(this.getFilterBy()) + ", pageSize=" + this.getPageSize() + ", withTotalCount=" + this.isWithTotalCount() + ")";
    }

    @Generated
    public DtoPageRequest() {
        this.filterBy = DtoPageRequest.$default$filterBy();
        this.pageSize = DtoPageRequest.$default$pageSize();
    }

    @Generated
    public DtoPageRequest(Map<String, Order> orderBy, DtoFilterList filterBy, int pageSize, boolean withTotalCount) {
        this.orderBy = orderBy;
        this.filterBy = filterBy;
        this.pageSize = pageSize;
        this.withTotalCount = withTotalCount;
    }

    @Generated
    public static class DtoPageRequestBuilder {
        @Generated
        private Map<String, Order> orderBy;
        @Generated
        private boolean filterBy$set;
        @Generated
        private DtoFilterList filterBy$value;
        @Generated
        private boolean pageSize$set;
        @Generated
        private int pageSize$value;
        @Generated
        private boolean withTotalCount;

        @Generated
        DtoPageRequestBuilder() {
        }

        @Generated
        public DtoPageRequestBuilder orderBy(Map<String, Order> orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Generated
        public DtoPageRequestBuilder filterBy(DtoFilterList filterBy) {
            this.filterBy$value = filterBy;
            this.filterBy$set = true;
            return this;
        }

        @Generated
        public DtoPageRequestBuilder pageSize(int pageSize) {
            this.pageSize$value = pageSize;
            this.pageSize$set = true;
            return this;
        }

        @Generated
        public DtoPageRequestBuilder withTotalCount(boolean withTotalCount) {
            this.withTotalCount = withTotalCount;
            return this;
        }

        @Generated
        public DtoPageRequest build() {
            DtoFilterList filterBy$value = this.filterBy$value;
            if (!this.filterBy$set) {
                filterBy$value = DtoPageRequest.$default$filterBy();
            }
            int pageSize$value = this.pageSize$value;
            if (!this.pageSize$set) {
                pageSize$value = DtoPageRequest.$default$pageSize();
            }
            return new DtoPageRequest(this.orderBy, filterBy$value, pageSize$value, this.withTotalCount);
        }

        @Generated
        public String toString() {
            return "DtoPageRequest.DtoPageRequestBuilder(orderBy=" + String.valueOf(this.orderBy) + ", filterBy$value=" + String.valueOf(this.filterBy$value) + ", pageSize$value=" + this.pageSize$value + ", withTotalCount=" + this.withTotalCount + ")";
        }
    }

    public static abstract class DtoFilter
    implements DtoFilterElement {
        @JsonIgnore
        private String attribute;
        @JsonIgnore
        private List<String> values;

        public abstract Filter create(Attribute var1, List<? extends Comparable<?>> var2);

        @JsonAnyGetter
        public Map<String, List<String>> getJson() {
            return Map.of(this.attribute, this.values);
        }

        @JsonAnySetter
        public void setAttribute(String name, Object value) {
            List<Object> list;
            this.attribute = name;
            if (value instanceof List) {
                List l = (List)value;
                list = l.stream().map(Objects::toString).toList();
            } else {
                list = List.of();
            }
            this.values = list;
        }

        @Generated
        protected DtoFilter(DtoFilterBuilder<?, ?> b) {
            this.attribute = b.attribute;
            this.values = switch (b.values == null ? 0 : b.values.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.values.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.values));
            };
        }

        @Generated
        public String getAttribute() {
            return this.attribute;
        }

        @Generated
        public List<String> getValues() {
            return this.values;
        }

        @JsonIgnore
        @Generated
        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @JsonIgnore
        @Generated
        public void setValues(List<String> values) {
            this.values = values;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DtoFilter)) {
                return false;
            }
            DtoFilter other = (DtoFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$attribute = this.getAttribute();
            String other$attribute = other.getAttribute();
            if (this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute)) {
                return false;
            }
            List<String> this$values = this.getValues();
            List<String> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DtoFilter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $attribute = this.getAttribute();
            result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
            List<String> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DtoPageRequest.DtoFilter(attribute=" + this.getAttribute() + ", values=" + String.valueOf(this.getValues()) + ")";
        }

        @Generated
        public DtoFilter() {
        }

        @Generated
        public static abstract class DtoFilterBuilder<C extends DtoFilter, B extends DtoFilterBuilder<C, B>> {
            @Generated
            private String attribute;
            @Generated
            private ArrayList<String> values;

            @JsonIgnore
            @Generated
            public B attribute(String attribute) {
                this.attribute = attribute;
                return this.self();
            }

            @Generated
            public B value(String value) {
                if (this.values == null) {
                    this.values = new ArrayList();
                }
                this.values.add(value);
                return this.self();
            }

            @JsonIgnore
            @Generated
            public B values(Collection<? extends String> values) {
                if (values == null) {
                    throw new NullPointerException("values cannot be null");
                }
                if (this.values == null) {
                    this.values = new ArrayList();
                }
                this.values.addAll(values);
                return this.self();
            }

            @Generated
            public B clearValues() {
                if (this.values != null) {
                    this.values.clear();
                }
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DtoPageRequest.DtoFilter.DtoFilterBuilder(attribute=" + this.attribute + ", values=" + String.valueOf(this.values) + ")";
            }
        }
    }

    @JsonTypeName(value="AND")
    @JsonDeserialize(using=DtoAndFilterListDeserializer.class)
    public static class DtoAndFilter
    extends DtoFilterList {
        @JsonAnySetter
        public void setContent(Map<String, List<DtoFilterElement>> filters) {
            this.setFilters(filters.entrySet().iterator().next().getValue());
        }

        @Generated
        protected DtoAndFilter(DtoAndFilterBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DtoAndFilterBuilder<?, ?> builder() {
            return new DtoAndFilterBuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "DtoPageRequest.DtoAndFilter()";
        }

        @Generated
        public DtoAndFilter() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DtoAndFilter)) {
                return false;
            }
            DtoAndFilter other = (DtoAndFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DtoAndFilter;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        private static final class DtoAndFilterBuilderImpl
        extends DtoAndFilterBuilder<DtoAndFilter, DtoAndFilterBuilderImpl> {
            @Generated
            private DtoAndFilterBuilderImpl() {
            }

            @Override
            @Generated
            protected DtoAndFilterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DtoAndFilter build() {
                return new DtoAndFilter(this);
            }
        }

        @Generated
        public static abstract class DtoAndFilterBuilder<C extends DtoAndFilter, B extends DtoAndFilterBuilder<C, B>>
        extends DtoFilterList.DtoFilterListBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "DtoPageRequest.DtoAndFilter.DtoAndFilterBuilder(super=" + super.toString() + ")";
            }
        }
    }

    @JsonTypeName(value="OR")
    @JsonDeserialize(using=DtoOrFilterListDeserializer.class)
    public static class DtoOrFilter
    extends DtoFilterList {
        @Generated
        protected DtoOrFilter(DtoOrFilterBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DtoOrFilterBuilder<?, ?> builder() {
            return new DtoOrFilterBuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "DtoPageRequest.DtoOrFilter()";
        }

        @Generated
        public DtoOrFilter() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DtoOrFilter)) {
                return false;
            }
            DtoOrFilter other = (DtoOrFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DtoOrFilter;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        private static final class DtoOrFilterBuilderImpl
        extends DtoOrFilterBuilder<DtoOrFilter, DtoOrFilterBuilderImpl> {
            @Generated
            private DtoOrFilterBuilderImpl() {
            }

            @Override
            @Generated
            protected DtoOrFilterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DtoOrFilter build() {
                return new DtoOrFilter(this);
            }
        }

        @Generated
        public static abstract class DtoOrFilterBuilder<C extends DtoOrFilter, B extends DtoOrFilterBuilder<C, B>>
        extends DtoFilterList.DtoFilterListBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "DtoPageRequest.DtoOrFilter.DtoOrFilterBuilder(super=" + super.toString() + ")";
            }
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=DtoAndFilter.class, name="AND"), @JsonSubTypes.Type(value=DtoOrFilter.class, name="OR"), @JsonSubTypes.Type(value=DtoEqFilter.class, name="EQ"), @JsonSubTypes.Type(value=DtoGtFilter.class, name="GT"), @JsonSubTypes.Type(value=DtoLtFilter.class, name="LT"), @JsonSubTypes.Type(value=DtoLikeFilter.class, name="LIKE")})
    public static interface DtoFilterElement {
    }

    public static abstract class DtoFilterList
    implements DtoFilterElement,
    Iterable<DtoFilterElement> {
        private List<DtoFilterElement> filters;

        @JsonValue
        public List<DtoFilterElement> getFilters() {
            return this.filters;
        }

        @Override
        public Iterator<DtoFilterElement> iterator() {
            return this.filters.iterator();
        }

        @Override
        public void forEach(Consumer<? super DtoFilterElement> action) {
            this.filters.forEach(action);
        }

        public int size() {
            return this.filters.size();
        }

        @Generated
        protected DtoFilterList(DtoFilterListBuilder<?, ?> b) {
            this.filters = switch (b.filters == null ? 0 : b.filters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.filters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<DtoFilterElement>(b.filters));
            };
        }

        @Generated
        public void setFilters(List<DtoFilterElement> filters) {
            this.filters = filters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DtoFilterList)) {
                return false;
            }
            DtoFilterList other = (DtoFilterList)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<DtoFilterElement> this$filters = this.getFilters();
            List<DtoFilterElement> other$filters = other.getFilters();
            return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DtoFilterList;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<DtoFilterElement> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DtoPageRequest.DtoFilterList(filters=" + String.valueOf(this.getFilters()) + ")";
        }

        @Generated
        public DtoFilterList() {
        }

        @Generated
        public DtoFilterList(List<DtoFilterElement> filters) {
            this.filters = filters;
        }

        @Generated
        public static abstract class DtoFilterListBuilder<C extends DtoFilterList, B extends DtoFilterListBuilder<C, B>> {
            @Generated
            private ArrayList<DtoFilterElement> filters;

            @Generated
            public B filter(DtoFilterElement filter) {
                if (this.filters == null) {
                    this.filters = new ArrayList();
                }
                this.filters.add(filter);
                return this.self();
            }

            @Generated
            public B filters(Collection<? extends DtoFilterElement> filters) {
                if (filters == null) {
                    throw new NullPointerException("filters cannot be null");
                }
                if (this.filters == null) {
                    this.filters = new ArrayList();
                }
                this.filters.addAll(filters);
                return this.self();
            }

            @Generated
            public B clearFilters() {
                if (this.filters != null) {
                    this.filters.clear();
                }
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "DtoPageRequest.DtoFilterList.DtoFilterListBuilder(filters=" + String.valueOf(this.filters) + ")";
            }
        }
    }

    public static class DtoOrFilterListDeserializer
    extends DtoFilterListDeserializer {
        public DtoOrFilterListDeserializer() {
            super(DtoOrFilter.class);
        }

        @Override
        protected DtoFilterList create(List<DtoFilterElement> filters) {
            return ((DtoOrFilter.DtoOrFilterBuilder)DtoOrFilter.builder().filters(filters)).build();
        }
    }

    public static class DtoAndFilterListDeserializer
    extends DtoFilterListDeserializer {
        public DtoAndFilterListDeserializer() {
            super(DtoAndFilter.class);
        }

        @Override
        protected DtoFilterList create(List<DtoFilterElement> filters) {
            return ((DtoAndFilter.DtoAndFilterBuilder)DtoAndFilter.builder().filters(filters)).build();
        }
    }

    public static abstract class DtoFilterListDeserializer
    extends StdDeserializer<DtoFilterList> {
        protected DtoFilterListDeserializer(Class<? extends DtoFilterList> vc) {
            super(vc);
        }

        public DtoFilterList deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            LinkedList<DtoFilterElement> filterList = new LinkedList<DtoFilterElement>();
            for (JsonNode n : node) {
                filterList.add((DtoFilterElement)jp.getCodec().treeToValue((TreeNode)n, DtoFilterElement.class));
            }
            return this.create(filterList);
        }

        protected abstract DtoFilterList create(List<DtoFilterElement> var1);
    }

    @JsonTypeName(value="LIKE")
    public static class DtoLikeFilter
    extends DtoFilter {
        @Override
        public Filter create(Attribute attribute, List<? extends Comparable<?>> values) {
            return Filters.attribute((Attribute)attribute).like(values);
        }

        @Generated
        protected DtoLikeFilter(DtoLikeFilterBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DtoLikeFilterBuilder<?, ?> builder() {
            return new DtoLikeFilterBuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "DtoPageRequest.DtoLikeFilter()";
        }

        @Generated
        public DtoLikeFilter() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DtoLikeFilter)) {
                return false;
            }
            DtoLikeFilter other = (DtoLikeFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DtoLikeFilter;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        private static final class DtoLikeFilterBuilderImpl
        extends DtoLikeFilterBuilder<DtoLikeFilter, DtoLikeFilterBuilderImpl> {
            @Generated
            private DtoLikeFilterBuilderImpl() {
            }

            @Override
            @Generated
            protected DtoLikeFilterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DtoLikeFilter build() {
                return new DtoLikeFilter(this);
            }
        }

        @Generated
        public static abstract class DtoLikeFilterBuilder<C extends DtoLikeFilter, B extends DtoLikeFilterBuilder<C, B>>
        extends DtoFilter.DtoFilterBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "DtoPageRequest.DtoLikeFilter.DtoLikeFilterBuilder(super=" + super.toString() + ")";
            }
        }
    }

    @JsonTypeName(value="LT")
    public static class DtoLtFilter
    extends DtoFilter {
        @Override
        public Filter create(Attribute attribute, List<? extends Comparable<?>> values) {
            return Filters.attribute((Attribute)attribute).lessThan(values);
        }

        @Generated
        protected DtoLtFilter(DtoLtFilterBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DtoLtFilterBuilder<?, ?> builder() {
            return new DtoLtFilterBuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "DtoPageRequest.DtoLtFilter()";
        }

        @Generated
        public DtoLtFilter() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DtoLtFilter)) {
                return false;
            }
            DtoLtFilter other = (DtoLtFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DtoLtFilter;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        private static final class DtoLtFilterBuilderImpl
        extends DtoLtFilterBuilder<DtoLtFilter, DtoLtFilterBuilderImpl> {
            @Generated
            private DtoLtFilterBuilderImpl() {
            }

            @Override
            @Generated
            protected DtoLtFilterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DtoLtFilter build() {
                return new DtoLtFilter(this);
            }
        }

        @Generated
        public static abstract class DtoLtFilterBuilder<C extends DtoLtFilter, B extends DtoLtFilterBuilder<C, B>>
        extends DtoFilter.DtoFilterBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "DtoPageRequest.DtoLtFilter.DtoLtFilterBuilder(super=" + super.toString() + ")";
            }
        }
    }

    @JsonTypeName(value="GT")
    public static class DtoGtFilter
    extends DtoFilter {
        @Override
        public Filter create(Attribute attribute, List<? extends Comparable<?>> values) {
            return Filters.attribute((Attribute)attribute).greaterThan(values);
        }

        @Generated
        protected DtoGtFilter(DtoGtFilterBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DtoGtFilterBuilder<?, ?> builder() {
            return new DtoGtFilterBuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "DtoPageRequest.DtoGtFilter()";
        }

        @Generated
        public DtoGtFilter() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DtoGtFilter)) {
                return false;
            }
            DtoGtFilter other = (DtoGtFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DtoGtFilter;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        private static final class DtoGtFilterBuilderImpl
        extends DtoGtFilterBuilder<DtoGtFilter, DtoGtFilterBuilderImpl> {
            @Generated
            private DtoGtFilterBuilderImpl() {
            }

            @Override
            @Generated
            protected DtoGtFilterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DtoGtFilter build() {
                return new DtoGtFilter(this);
            }
        }

        @Generated
        public static abstract class DtoGtFilterBuilder<C extends DtoGtFilter, B extends DtoGtFilterBuilder<C, B>>
        extends DtoFilter.DtoFilterBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "DtoPageRequest.DtoGtFilter.DtoGtFilterBuilder(super=" + super.toString() + ")";
            }
        }
    }

    @JsonTypeName(value="EQ")
    public static class DtoEqFilter
    extends DtoFilter {
        @Override
        public Filter create(Attribute attribute, List<? extends Comparable<?>> values) {
            return Filters.attribute((Attribute)attribute).equalTo(values);
        }

        @Generated
        protected DtoEqFilter(DtoEqFilterBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DtoEqFilterBuilder<?, ?> builder() {
            return new DtoEqFilterBuilderImpl();
        }

        @Override
        @Generated
        public String toString() {
            return "DtoPageRequest.DtoEqFilter()";
        }

        @Generated
        public DtoEqFilter() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DtoEqFilter)) {
                return false;
            }
            DtoEqFilter other = (DtoEqFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DtoEqFilter;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        private static final class DtoEqFilterBuilderImpl
        extends DtoEqFilterBuilder<DtoEqFilter, DtoEqFilterBuilderImpl> {
            @Generated
            private DtoEqFilterBuilderImpl() {
            }

            @Override
            @Generated
            protected DtoEqFilterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DtoEqFilter build() {
                return new DtoEqFilter(this);
            }
        }

        @Generated
        public static abstract class DtoEqFilterBuilder<C extends DtoEqFilter, B extends DtoEqFilterBuilder<C, B>>
        extends DtoFilter.DtoFilterBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "DtoPageRequest.DtoEqFilter.DtoEqFilterBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

