/*
 * Decompiled with CFR 0.152.
 */
package io.vigier.cursorpaging.jpa.serializer;

import jakarta.validation.ValidationException;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.stream.IntStream;

public class Base64String
implements CharSequence {
    private final String encoded;

    public Base64String(String base64String) {
        this.encoded = this.validate(base64String);
    }

    public Base64String(byte[] bytes) {
        this.encoded = new String(bytes, StandardCharsets.UTF_8);
    }

    public static Base64String encode(byte[] content) {
        return new Base64String(Base64.getUrlEncoder().encode(content));
    }

    private String validate(String base64String) {
        if (base64String.isEmpty()) {
            throw new ValidationException("Base64 string must not be empty");
        }
        try {
            Base64String.decode(base64String);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Argument string must be a valid Base64 string : '%s'".formatted(base64String), (Throwable)e);
        }
        return base64String;
    }

    public byte[] decoded() {
        return Base64String.decode(this.encoded);
    }

    private static byte[] decode(String base64String) {
        return Base64.getUrlDecoder().decode(base64String);
    }

    @Override
    public int length() {
        return this.encoded.length();
    }

    @Override
    public char charAt(int index) {
        return this.encoded.charAt(index);
    }

    @Override
    public boolean isEmpty() {
        return this.encoded.isEmpty();
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.encoded.subSequence(start, end);
    }

    @Override
    @NotNull
    public IntStream chars() {
        return this.encoded.chars();
    }

    @Override
    @NotNull
    public IntStream codePoints() {
        return this.encoded.codePoints();
    }

    @Override
    @NotNull
    public String toString() {
        return this.encoded;
    }

    public Base64String replace(String target, String replacement) {
        return new Base64String(this.encoded.replace(target, replacement));
    }
}

