/*
 * Decompiled with CFR 0.152.
 */
package io.vigier.cursorpaging.jpa.serializer;

import io.vigier.cursorpaging.jpa.serializer.CryptoException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.random.RandomGenerator;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;

public class Encrypter {
    public static final String KEY_ALGORITHM = "ChaCha20";
    public static final int IV_BYTES_LENGTH = 12;
    private static final String ALGORITHM = "ChaCha20-Poly1305";
    private final RandomGenerator randomGenerator;
    private final SecretKey secret;

    public byte[] encrypt(byte[] data) {
        try {
            return this.doEncrypt(data);
        }
        catch (RuntimeException e) {
            throw new CryptoException(e.getCause());
        }
    }

    private byte[] doEncrypt(byte[] data) {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec(this.getIvBytes());
        cipher.init(1, (Key)this.secret, iv);
        byte[] encrypted = cipher.doFinal(data);
        return ByteBuffer.allocate(encrypted.length + 12).put(encrypted).put(iv.getIV()).array();
    }

    private byte[] getIvBytes() {
        byte[] iv = new byte[12];
        this.randomGenerator.nextBytes(iv);
        return iv;
    }

    public byte[] decrypt(byte[] data) {
        try {
            return this.doDecrypt(data);
        }
        catch (RuntimeException e) {
            throw new CryptoException(e.getCause());
        }
    }

    private byte[] doDecrypt(byte[] data) {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec(data, data.length - 12, 12);
        cipher.init(2, (Key)this.secret, iv);
        return cipher.doFinal(data, 0, data.length - 12);
    }

    public static Encrypter getInstance() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(KEY_ALGORITHM);
            keyGen.init(256, SecureRandom.getInstanceStrong());
            return Encrypter.builder().secret(keyGen.generateKey()).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static Encrypter getInstance(SecretKey key) {
        if (!key.getAlgorithm().equals(KEY_ALGORITHM) || key.getEncoded().length != 32) {
            throw new IllegalArgumentException("Invalid key algorithm '%s', should be '%s' and byte-length (%s) must be 32 byte".formatted(key.getAlgorithm(), KEY_ALGORITHM, key.getEncoded().length));
        }
        return Encrypter.builder().secret(key).build();
    }

    public static Encrypter getInstance(String secret) {
        return Encrypter.getInstance(Encrypter.getKey(secret));
    }

    public static SecretKey getKey(String secret) {
        return new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), KEY_ALGORITHM);
    }

    @Generated
    private static RandomGenerator $default$randomGenerator() {
        return new SecureRandom(UUID.randomUUID().toString().getBytes());
    }

    @Generated
    public static EncrypterBuilder builder() {
        return new EncrypterBuilder();
    }

    @Generated
    public Encrypter(RandomGenerator randomGenerator, SecretKey secret) {
        this.randomGenerator = randomGenerator;
        this.secret = secret;
    }

    @Generated
    public static class EncrypterBuilder {
        @Generated
        private boolean randomGenerator$set;
        @Generated
        private RandomGenerator randomGenerator$value;
        @Generated
        private SecretKey secret;

        @Generated
        EncrypterBuilder() {
        }

        @Generated
        public EncrypterBuilder randomGenerator(RandomGenerator randomGenerator) {
            this.randomGenerator$value = randomGenerator;
            this.randomGenerator$set = true;
            return this;
        }

        @Generated
        public EncrypterBuilder secret(SecretKey secret) {
            this.secret = secret;
            return this;
        }

        @Generated
        public Encrypter build() {
            RandomGenerator randomGenerator$value = this.randomGenerator$value;
            if (!this.randomGenerator$set) {
                randomGenerator$value = Encrypter.$default$randomGenerator();
            }
            return new Encrypter(randomGenerator$value, this.secret);
        }

        @Generated
        public String toString() {
            return "Encrypter.EncrypterBuilder(randomGenerator$value=" + String.valueOf(this.randomGenerator$value) + ", secret=" + String.valueOf(this.secret) + ")";
        }
    }
}

