/*
 * Decompiled with CFR 0.152.
 */
package io.vigier.cursorpaging.jpa.serializer;

import io.vigier.cursorpaging.jpa.Attribute;
import io.vigier.cursorpaging.jpa.Filter;
import io.vigier.cursorpaging.jpa.FilterRule;
import io.vigier.cursorpaging.jpa.Order;
import io.vigier.cursorpaging.jpa.PageRequest;
import io.vigier.cursorpaging.jpa.Position;
import io.vigier.cursorpaging.jpa.filter.AndFilter;
import io.vigier.cursorpaging.jpa.filter.FilterBuilder;
import io.vigier.cursorpaging.jpa.filter.FilterList;
import io.vigier.cursorpaging.jpa.filter.OrFilter;
import io.vigier.cursorpaging.jpa.serializer.RuleFactory;
import io.vigier.cursorpaging.jpa.serializer.SerializerException;
import io.vigier.cursorpaging.jpa.serializer.dto.Cursor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;

class FromDtoMapper<E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FromDtoMapper.class);
    private static final Map<Cursor.FilterType, FilterBuilder.FilterType> FILTER_TYPE_MAP = Map.of(Cursor.FilterType.EQ, FilterBuilder.FilterType.EQUAL, Cursor.FilterType.GT, FilterBuilder.FilterType.GREATER_THAN, Cursor.FilterType.LT, FilterBuilder.FilterType.LESS_THAN, Cursor.FilterType.LIKE, FilterBuilder.FilterType.LIKE, Cursor.FilterType.UNRECOGNIZED, FilterBuilder.FilterType.EQUAL);
    private final Cursor.PageRequest request;
    private final Map<String, Attribute> attributesByName;
    private final ConversionService conversionService;
    private final Map<String, RuleFactory> ruleFactories;

    public static <T> FromDtoMapper<T> create(Consumer<FromDtoMapperBuilder<T>> c) {
        FromDtoMapperBuilder builder = FromDtoMapper.builder();
        c.accept(builder);
        return builder.build();
    }

    public PageRequest<E> map() {
        return PageRequest.builder().positions(this.positions()).filters(this.filters()).pageSize(this.request.getPageSize()).enableTotalCount(this.request.hasTotalCount()).totalCount(this.request.hasTotalCount() ? Long.valueOf(this.request.getTotalCount()) : null).rules(this.filterRules()).build();
    }

    private List<FilterRule> filterRules() {
        return this.request.getFilterRulesList().stream().map(this::filterRuleOf).filter(Objects::nonNull).toList();
    }

    private FilterRule filterRuleOf(Cursor.Rule rule) {
        RuleFactory factory = this.ruleFactories.get(rule.getName());
        if (factory != null) {
            HashMap parameters = new HashMap();
            rule.getParametersList().forEach(p -> parameters.put(p.getName(), p.getValuesList().stream().map(Cursor.Value::getValue).toList()));
            return (FilterRule)factory.apply(parameters);
        }
        return null;
    }

    private Collection<Position> positions() {
        return this.request.getPositionsList().stream().map(this::positionOf).toList();
    }

    private FilterList filters() {
        return this.fromFilterListDto(this.request.getFilters());
    }

    private FilterList fromFilterListDto(Cursor.FilterList dto) {
        LinkedList<Object> filters = new LinkedList<Object>();
        filters.addAll(dto.getFiltersList().stream().map(this::fromFilterDto).toList());
        filters.addAll(dto.getFilterListsList().stream().map(this::fromFilterListDto).toList());
        return switch (dto.getType()) {
            default -> throw new MatchException(null, null);
            case Cursor.FilterList.FilterListType.AND, Cursor.FilterList.FilterListType.UNRECOGNIZED -> AndFilter.of(filters);
            case Cursor.FilterList.FilterListType.OR -> OrFilter.of(filters);
        };
    }

    private Filter fromFilterDto(Cursor.Filter dto) {
        Attribute attribute = this.attributeOf(dto.getAttribute());
        List<Comparable<?>> values = this.valueListOf(attribute, dto.getValuesList());
        return Filter.builder().attribute(attribute).values(values).type(this.getFilterType(dto)).build();
    }

    private FilterBuilder.FilterType getFilterType(Cursor.Filter dto) {
        return FILTER_TYPE_MAP.get((Object)dto.getType());
    }

    private List<? extends Comparable<?>> valueListOf(Attribute attribute, List<Cursor.Value> valuesList) {
        return valuesList.stream().map(v -> {
            Object converted = this.valueOf(attribute, (Cursor.Value)v);
            log.trace("Converted: {} into {} (value={})", new Object[]{v.getClass().getSimpleName(), converted != null ? converted.getClass().getSimpleName() : null, converted});
            return converted;
        }).toList();
    }

    private <T extends Comparable<? super T>> T valueOf(Attribute attribute, Cursor.Value value) {
        if (value.getValue().isEmpty()) {
            return null;
        }
        Comparable convert = (Comparable)this.conversionService.convert((Object)value.getValue(), attribute.type());
        if (convert == null) {
            throw new SerializerException("Cannot convert value: " + value.getValue() + " to type: " + String.valueOf(attribute.type()));
        }
        return (T)convert;
    }

    private Position positionOf(Cursor.Position position) {
        Attribute attribute = this.attributeOf(position.getAttribute());
        return Position.create((T b) -> {
            Position.PositionBuilder positionBuilder = b.attribute(attribute).value(this.valueOf(attribute, position.getValue()));
            positionBuilder.order(switch (position.getOrder()) {
                default -> throw new MatchException(null, null);
                case Cursor.Order.ASC -> Order.ASC;
                case Cursor.Order.DESC -> Order.DESC;
                case Cursor.Order.UNRECOGNIZED -> throw new IllegalArgumentException("Unrecognized order");
            }).reversed(position.getReversed());
        });
    }

    private Attribute attributeOf(Cursor.Attribute attribute) {
        Attribute cursorAttribute = this.attributesByName.get(attribute.getName());
        if (cursorAttribute == null) {
            throw new IllegalArgumentException("No attribute found for name: " + attribute.getName());
        }
        return cursorAttribute;
    }

    @Generated
    private static <E> Map<String, Attribute> $default$attributesByName() {
        return new HashMap<String, Attribute>();
    }

    @Generated
    public static <E> FromDtoMapperBuilder<E> builder() {
        return new FromDtoMapperBuilder();
    }

    @Generated
    private FromDtoMapper(Cursor.PageRequest request, Map<String, Attribute> attributesByName, ConversionService conversionService, Map<String, RuleFactory> ruleFactories) {
        this.request = request;
        this.attributesByName = attributesByName;
        this.conversionService = conversionService;
        this.ruleFactories = ruleFactories;
    }

    @Generated
    public static <E> FromDtoMapper<E> of(Cursor.PageRequest request, Map<String, Attribute> attributesByName, ConversionService conversionService, Map<String, RuleFactory> ruleFactories) {
        return new FromDtoMapper<E>(request, attributesByName, conversionService, ruleFactories);
    }

    @Generated
    public static class FromDtoMapperBuilder<E> {
        @Generated
        private Cursor.PageRequest request;
        @Generated
        private boolean attributesByName$set;
        @Generated
        private Map<String, Attribute> attributesByName$value;
        @Generated
        private ConversionService conversionService;
        @Generated
        private Map<String, RuleFactory> ruleFactories;

        @Generated
        FromDtoMapperBuilder() {
        }

        @Generated
        public FromDtoMapperBuilder<E> request(Cursor.PageRequest request) {
            this.request = request;
            return this;
        }

        @Generated
        public FromDtoMapperBuilder<E> attributesByName(Map<String, Attribute> attributesByName) {
            this.attributesByName$value = attributesByName;
            this.attributesByName$set = true;
            return this;
        }

        @Generated
        public FromDtoMapperBuilder<E> conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        @Generated
        public FromDtoMapperBuilder<E> ruleFactories(Map<String, RuleFactory> ruleFactories) {
            this.ruleFactories = ruleFactories;
            return this;
        }

        @Generated
        public FromDtoMapper<E> build() {
            Map<String, Attribute> attributesByName$value = this.attributesByName$value;
            if (!this.attributesByName$set) {
                attributesByName$value = FromDtoMapper.$default$attributesByName();
            }
            return new FromDtoMapper(this.request, attributesByName$value, this.conversionService, this.ruleFactories);
        }

        @Generated
        public String toString() {
            return "FromDtoMapper.FromDtoMapperBuilder(request=" + String.valueOf(this.request) + ", attributesByName$value=" + String.valueOf(this.attributesByName$value) + ", conversionService=" + String.valueOf(this.conversionService) + ", ruleFactories=" + String.valueOf(this.ruleFactories) + ")";
        }
    }
}

