/*
 * Decompiled with CFR 0.152.
 */
package io.vigier.cursorpaging.jpa.serializer;

import io.vigier.cursorpaging.jpa.Attribute;
import io.vigier.cursorpaging.jpa.PageRequest;
import io.vigier.cursorpaging.jpa.serializer.Base64String;
import io.vigier.cursorpaging.jpa.serializer.Encrypter;
import io.vigier.cursorpaging.jpa.serializer.FromDtoMapper;
import io.vigier.cursorpaging.jpa.serializer.RuleFactory;
import io.vigier.cursorpaging.jpa.serializer.ToDtoMapper;
import io.vigier.cursorpaging.jpa.serializer.dto.Cursor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;

public class RequestSerializer<E> {
    private Map<String, Attribute> attributes;
    private final Encrypter encrypter;
    private final ConversionService conversionService;
    private final Map<String, RuleFactory> filterRuleFactories;

    public static <E> RequestSerializer<E> create(Consumer<RequestSerializerBuilder<E>> c) {
        RequestSerializerBuilder<E> builder = RequestSerializer.builder();
        c.accept(builder);
        return builder.build();
    }

    public static <E> RequestSerializer<E> create() {
        return RequestSerializer.create(b -> {});
    }

    public byte[] toBytes(PageRequest<E> page) {
        this.updateAttributes(page);
        Cursor.PageRequest dtoRequest = ToDtoMapper.create((ToDtoMapper.ToDtoMapperBuilder<E> c) -> c.pageRequest(page)).map();
        return this.encrypter.encrypt(dtoRequest.toByteArray());
    }

    private void updateAttributes(PageRequest<E> page) {
        page.positions().forEach(p -> this.attributes.putIfAbsent(p.attribute().name(), p.attribute()));
        page.filters().attributes().forEach(a -> this.attributes.putIfAbsent(a.name(), (Attribute)a));
    }

    public Base64String toBase64(PageRequest<E> page) {
        return Base64String.encode(this.toBytes(page)).replace("=", "");
    }

    public PageRequest<E> toPageRequest(byte[] data) {
        Cursor.PageRequest request = Cursor.PageRequest.parseFrom(this.encrypter.decrypt(data));
        FromDtoMapper fromDtoMapper = FromDtoMapper.create((FromDtoMapper.FromDtoMapperBuilder<T> b) -> b.request(request).conversionService(this.conversionService).ruleFactories(this.filterRuleFactories).attributesByName(this.attributes));
        return fromDtoMapper.map();
    }

    public PageRequest<E> toPageRequest(Base64String base64) {
        return this.toPageRequest(base64.decoded());
    }

    public Optional<PageRequest<E>> stringToPageRequest(@Nullable String cursorStr) {
        return Optional.ofNullable(cursorStr != null ? (!cursorStr.isBlank() ? cursorStr : null) : null).map(Base64String::new).map(this::toPageRequest);
    }

    @Generated
    private static <E> Map<String, Attribute> $default$attributes() {
        return new ConcurrentHashMap<String, Attribute>();
    }

    @Generated
    private static <E> Encrypter $default$encrypter() {
        return Encrypter.getInstance();
    }

    @Generated
    private static <E> ConversionService $default$conversionService() {
        return new ConversionService(){

            public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
                if (sourceType == null || targetType == null) {
                    return false;
                }
                return sourceType.isAssignableFrom(String.class) && (targetType.isAssignableFrom(Long.class) || targetType.isAssignableFrom(Integer.class) || targetType.isAssignableFrom(Boolean.class) || targetType.isAssignableFrom(String.class) || targetType.isAssignableFrom(Object.class));
            }

            public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (sourceType == null || targetType == null) {
                    return false;
                }
                return this.canConvert(sourceType.getType(), targetType.getType());
            }

            public <T> T convert(Object source, Class<T> targetType) {
                if (targetType == String.class) {
                    return (T)source.toString();
                }
                if (targetType == Integer.class) {
                    return (T)Integer.valueOf(source.toString());
                }
                if (targetType == Long.class) {
                    return (T)Long.valueOf(source.toString());
                }
                if (targetType == Boolean.class) {
                    return (T)Boolean.valueOf(source.toString().equals("true"));
                }
                if (targetType == Object.class) {
                    return (T)source;
                }
                return null;
            }

            public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
                return this.convert(source, targetType.getObjectType());
            }
        };
    }

    @Generated
    private static <E> Map<String, RuleFactory> $default$filterRuleFactories() {
        return new HashMap<String, RuleFactory>();
    }

    @Generated
    RequestSerializer(Map<String, Attribute> attributes, Encrypter encrypter, ConversionService conversionService, Map<String, RuleFactory> filterRuleFactories) {
        this.attributes = attributes;
        this.encrypter = encrypter;
        this.conversionService = conversionService;
        this.filterRuleFactories = filterRuleFactories;
    }

    @Generated
    public static <E> RequestSerializerBuilder<E> builder() {
        return new RequestSerializerBuilder();
    }

    public static class RequestSerializerBuilder<E> {
        @Generated
        private boolean attributes$set;
        @Generated
        private Map<String, Attribute> attributes$value;
        @Generated
        private boolean encrypter$set;
        @Generated
        private Encrypter encrypter$value;
        @Generated
        private boolean conversionService$set;
        @Generated
        private ConversionService conversionService$value;
        @Generated
        private boolean filterRuleFactories$set;
        @Generated
        private Map<String, RuleFactory> filterRuleFactories$value;

        public RequestSerializerBuilder<E> use(Attribute attribute) {
            if (this.attributes$value == null) {
                this.attributes$value = new ConcurrentHashMap<String, Attribute>();
            }
            this.attributes$value.put(attribute.name(), attribute);
            this.attributes$set = true;
            return this;
        }

        public RequestSerializerBuilder<E> filterRuleFactory(String name, RuleFactory factory) {
            if (this.filterRuleFactories$value == null) {
                this.filterRuleFactories$value = new HashMap<String, RuleFactory>();
            }
            this.filterRuleFactories$value.put(name, factory);
            this.filterRuleFactories$set = true;
            return this;
        }

        @Generated
        RequestSerializerBuilder() {
        }

        @Generated
        public RequestSerializerBuilder<E> attributes(Map<String, Attribute> attributes) {
            this.attributes$value = attributes;
            this.attributes$set = true;
            return this;
        }

        @Generated
        public RequestSerializerBuilder<E> encrypter(Encrypter encrypter) {
            this.encrypter$value = encrypter;
            this.encrypter$set = true;
            return this;
        }

        @Generated
        public RequestSerializerBuilder<E> conversionService(ConversionService conversionService) {
            this.conversionService$value = conversionService;
            this.conversionService$set = true;
            return this;
        }

        @Generated
        public RequestSerializerBuilder<E> filterRuleFactories(Map<String, RuleFactory> filterRuleFactories) {
            this.filterRuleFactories$value = filterRuleFactories;
            this.filterRuleFactories$set = true;
            return this;
        }

        @Generated
        public RequestSerializer<E> build() {
            Map<String, Attribute> attributes$value = this.attributes$value;
            if (!this.attributes$set) {
                attributes$value = RequestSerializer.$default$attributes();
            }
            Encrypter encrypter$value = this.encrypter$value;
            if (!this.encrypter$set) {
                encrypter$value = RequestSerializer.$default$encrypter();
            }
            ConversionService conversionService$value = this.conversionService$value;
            if (!this.conversionService$set) {
                conversionService$value = RequestSerializer.$default$conversionService();
            }
            Map<String, RuleFactory> filterRuleFactories$value = this.filterRuleFactories$value;
            if (!this.filterRuleFactories$set) {
                filterRuleFactories$value = RequestSerializer.$default$filterRuleFactories();
            }
            return new RequestSerializer(attributes$value, encrypter$value, conversionService$value, filterRuleFactories$value);
        }

        @Generated
        public String toString() {
            return "RequestSerializer.RequestSerializerBuilder(attributes$value=" + String.valueOf(this.attributes$value) + ", encrypter$value=" + String.valueOf(this.encrypter$value) + ", conversionService$value=" + String.valueOf(this.conversionService$value) + ", filterRuleFactories$value=" + String.valueOf(this.filterRuleFactories$value) + ")";
        }
    }
}

