/*
 * Decompiled with CFR 0.152.
 */
package io.vigier.cursorpaging.jpa.serializer;

import io.vigier.cursorpaging.jpa.Attribute;
import io.vigier.cursorpaging.jpa.Filter;
import io.vigier.cursorpaging.jpa.FilterRule;
import io.vigier.cursorpaging.jpa.Order;
import io.vigier.cursorpaging.jpa.PageRequest;
import io.vigier.cursorpaging.jpa.filter.AndFilter;
import io.vigier.cursorpaging.jpa.filter.EqualFilter;
import io.vigier.cursorpaging.jpa.filter.FilterList;
import io.vigier.cursorpaging.jpa.filter.GreaterThanFilter;
import io.vigier.cursorpaging.jpa.filter.LessThanFilter;
import io.vigier.cursorpaging.jpa.filter.LikeFilter;
import io.vigier.cursorpaging.jpa.filter.OrFilter;
import io.vigier.cursorpaging.jpa.serializer.dto.Cursor;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;

class ToDtoMapper<E> {
    private static final Map<Class<? extends Filter>, Cursor.FilterType> TYPE_MAP = Map.of(EqualFilter.class, Cursor.FilterType.EQ, GreaterThanFilter.class, Cursor.FilterType.GT, LessThanFilter.class, Cursor.FilterType.LT, LikeFilter.class, Cursor.FilterType.LIKE);
    private static final Map<Class<? extends FilterList>, Cursor.FilterList.FilterListType> LISTTYPE_MAP = Map.of(AndFilter.class, Cursor.FilterList.FilterListType.AND, OrFilter.class, Cursor.FilterList.FilterListType.OR);
    private final PageRequest<E> pageRequest;

    public static <E> ToDtoMapper<E> create(Consumer<ToDtoMapperBuilder<E>> c) {
        ToDtoMapperBuilder<E> builder = ToDtoMapper.builder();
        c.accept(builder);
        return builder.build();
    }

    public Cursor.PageRequest map() {
        Cursor.PageRequest.Builder builder = Cursor.PageRequest.newBuilder().addAllPositions(this.positions()).setPageSize(this.pageRequest.pageSize()).setFilters(this.filters()).addAllFilterRules(this.filterRules());
        this.pageRequest.totalCount().ifPresent(builder::setTotalCount);
        return builder.build();
    }

    private Iterable<Cursor.Rule> filterRules() {
        return this.pageRequest.rules().stream().map(r -> Cursor.Rule.newBuilder().setName(r.name()).addAllParameters(this.toDtoParameters((FilterRule)r)).build()).toList();
    }

    private List<Cursor.Rule.Parameter> toDtoParameters(FilterRule r) {
        return r.parameters().entrySet().stream().map(e -> Cursor.Rule.Parameter.newBuilder().setName((String)e.getKey()).addAllValues(((List)e.getValue()).stream().map(this::valueOf).toList()).build()).toList();
    }

    private Cursor.FilterList filters() {
        return this.toDto(this.pageRequest.filters());
    }

    private Cursor.FilterList toDto(FilterList list) {
        Cursor.FilterList.Builder b = Cursor.FilterList.newBuilder().setType(this.typeOf(list));
        list.forEach(f -> {
            if (f instanceof Filter) {
                Filter ff = (Filter)f;
                b.addFilters(Cursor.Filter.newBuilder().setAttribute(ToDtoMapper.attributeOf(ff.attribute())).addAllValues(ff.values().stream().map(this::valueOf).toList()).setType(this.typeOf(ff)).build());
            } else if (f instanceof FilterList) {
                FilterList fl = (FilterList)f;
                b.addFilterLists(this.toDto(fl));
            }
        });
        return b.build();
    }

    Cursor.FilterType typeOf(Filter f) {
        return TYPE_MAP.get(f.getClass());
    }

    Cursor.FilterList.FilterListType typeOf(FilterList f) {
        return LISTTYPE_MAP.get(f.getClass());
    }

    private Iterable<Cursor.Position> positions() {
        return this.pageRequest.positions().stream().map(p -> {
            Cursor.Position.Builder builder = Cursor.Position.newBuilder().setAttribute(ToDtoMapper.attributeOf(p.attribute())).setValue(this.valueOf(p.value()));
            return builder.setOrder(switch (p.order()) {
                default -> throw new MatchException(null, null);
                case Order.ASC -> Cursor.Order.ASC;
                case Order.DESC -> Cursor.Order.DESC;
            }).setReversed(p.reversed()).build();
        }).toList();
    }

    private static Cursor.Attribute attributeOf(Attribute attribute) {
        return Cursor.Attribute.newBuilder().setName(attribute.name()).build();
    }

    private Cursor.Value valueOf(Comparable<?> value) {
        if (value == null) {
            return Cursor.Value.newBuilder().setValue("").build();
        }
        if (value instanceof Instant) {
            Instant i = (Instant)value;
            return Cursor.Value.newBuilder().setValue("" + i.toEpochMilli()).build();
        }
        return Cursor.Value.newBuilder().setValue(value.toString()).build();
    }

    @Generated
    public static <E> ToDtoMapperBuilder<E> builder() {
        return new ToDtoMapperBuilder();
    }

    @Generated
    private ToDtoMapper(PageRequest<E> pageRequest) {
        this.pageRequest = pageRequest;
    }

    @Generated
    public static <E> ToDtoMapper<E> of(PageRequest<E> pageRequest) {
        return new ToDtoMapper<E>(pageRequest);
    }

    @Generated
    public static class ToDtoMapperBuilder<E> {
        @Generated
        private PageRequest<E> pageRequest;

        @Generated
        ToDtoMapperBuilder() {
        }

        @Generated
        public ToDtoMapperBuilder<E> pageRequest(PageRequest<E> pageRequest) {
            this.pageRequest = pageRequest;
            return this;
        }

        @Generated
        public ToDtoMapper<E> build() {
            return new ToDtoMapper<E>(this.pageRequest);
        }

        @Generated
        public String toString() {
            return "ToDtoMapper.ToDtoMapperBuilder(pageRequest=" + String.valueOf(this.pageRequest) + ")";
        }
    }
}

