/*
 * Decompiled with CFR 0.152.
 */
package minium.internal;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.WeakHashMap;
import minium.Elements;
import minium.internal.Locator;
import minium.internal.Throwables;
import platypus.AbstractMixinInitializer;
import platypus.InstanceProviders;
import platypus.Mixin;
import platypus.MixinClass;
import platypus.MixinInitializer;

public interface InternalLocator
extends Elements {
    public Elements eval(Elements var1);

    public boolean isRoot();

    public Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;

    public static class MethodInvocationImpl
    extends Impl
    implements InternalLocator {
        private final WeakHashMap<Elements, Elements> evalResults = new WeakHashMap();
        private final Method method;
        private final Object[] args;

        public MethodInvocationImpl(Locator<?> locator, InternalLocator parent, Method method, Object[] args) {
            super(locator, parent);
            this.method = method;
            this.args = args;
        }

        @Override
        public Elements eval(Elements root) {
            if (this.evalResults.containsKey(root)) {
                return this.evalResults.get(root);
            }
            Elements elems = root;
            if (this.parent != null) {
                elems = this.parent.eval(root);
            }
            try {
                Elements result = (Elements)this.method.invoke((Object)elems, this.evalArgs(root, this.args));
                this.evalResults.put(root, result);
                return result;
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate(e.getTargetException());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public String toString() {
            Object root = this.locator.getRoot();
            if (root == null) {
                return super.toString();
            }
            Elements elements = this.eval((Elements)root);
            return elements.toString();
        }

        private Object[] evalArgs(Elements root, Object[] args) {
            if (args == null) {
                return null;
            }
            Object[] evalArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg instanceof InternalLocator) {
                    arg = ((InternalLocator)arg).eval(root);
                }
                evalArgs[i] = arg;
            }
            return evalArgs;
        }
    }

    public static class Impl
    extends Mixin.Impl
    implements InternalLocator,
    InvocationHandler {
        protected final Locator<?> locator;
        protected final InternalLocator parent;

        public Impl(Locator<?> locator, InternalLocator parent) {
            this.locator = locator;
            this.parent = parent;
        }

        @Override
        public Elements eval(Elements elems) {
            return this.parent == null ? elems : this.parent.eval(elems);
        }

        @Override
        public boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> returnIntf = method.getReturnType();
            if (!Elements.class.isAssignableFrom(returnIntf)) {
                Object root = this.locator.getRoot();
                Preconditions.checkState((root != null ? 1 : 0) != 0, (String)"Method %s does not return an Elements class and Minium.get() does not return any root Elements", (Object)method);
                Elements elements = this.eval((Elements)root);
                return method.invoke((Object)elements, args);
            }
            return Impl.createInternalLocator(this.locator, this, method, args);
        }

        public String toString() {
            return String.format("%s.root()", this.locator);
        }

        public static <T> T createInternalLocator(Locator<?> locator, InternalLocator parent) {
            Impl internalLocator = new Impl(locator, parent);
            return Impl.doCreateInternalLocator(locator, internalLocator);
        }

        public static <T> T createInternalLocator(Locator<?> locator, InternalLocator parent, Method method, Object ... args) {
            MethodInvocationImpl internalLocator = new MethodInvocationImpl(locator, parent, method, args);
            return Impl.doCreateInternalLocator(locator, internalLocator);
        }

        private static <T> T doCreateInternalLocator(Locator<?> locator, final Impl internalLocator) {
            final MixinClass<?> mixinClass = locator.getMixinClass();
            return (T)mixinClass.newInstance((MixinInitializer)new AbstractMixinInitializer(){

                protected void initialize() {
                    this.implement(new Class[]{Object.class, InternalLocator.class}).with(InstanceProviders.ofInstance((Object)internalLocator));
                    this.implementRemainers().with(InstanceProviders.adapt((InvocationHandler)internalLocator, (Collection)mixinClass.getDeclaredInterfaces()));
                }
            });
        }
    }
}

