/*
 * Decompiled with CFR 0.152.
 */
package minium.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Doubles;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import minium.Dimension;
import minium.Offsets;
import minium.Point;
import minium.Rectangle;

public class InternalOffsets {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.####");

    static {
        DECIMAL_FORMAT.setPositivePrefix("+");
    }

    public static class Parser {
        private static final Pattern POS_REGEX = Pattern.compile("(?:(left|right|center)(?:([+-]\\d+(?:\\.\\d+)?)(%|px)?)?|(?:([+-]inf)))\\s+(?:(top|bottom|center|middle)(?:([+-]?\\d+(?:\\.\\d+)?)(%|px)?)?|(?:([+-]inf)))");

        public Offsets.Offset parse(String positionString) {
            Offsets.VerticalOffset vertical;
            Offsets.HorizontalOffset horizontal;
            Matcher matcher = POS_REGEX.matcher(positionString);
            if (!matcher.matches()) {
                throw new Offsets.ParseException(String.format("%s is not a valid offset", positionString));
            }
            if (Strings.isNullOrEmpty((String)matcher.group(4))) {
                horizontal = Offsets.HorizontalReference.of(matcher.group(1));
                horizontal = horizontal.plus(this.parseVal(matcher.group(2)), Offsets.Unit.of(matcher.group(3)));
            } else {
                horizontal = Offsets.HorizontalReference.of(matcher.group(4));
            }
            if (Strings.isNullOrEmpty((String)matcher.group(8))) {
                vertical = Offsets.VerticalReference.of(matcher.group(5));
                vertical = vertical.plus(this.parseVal(matcher.group(6)), Offsets.Unit.of(matcher.group(7)));
            } else {
                vertical = Offsets.VerticalReference.of(matcher.group(8));
            }
            return new OffsetImpl(horizontal, vertical);
        }

        protected double parseVal(String valStr) {
            if (Strings.isNullOrEmpty((String)valStr)) {
                return 0.0;
            }
            if (valStr.startsWith("+")) {
                valStr = valStr.substring(1);
            }
            return Double.parseDouble(valStr);
        }
    }

    public static class OffsetImpl
    implements Offsets.Offset {
        private final Offsets.HorizontalOffset horizontal;
        private final Offsets.VerticalOffset vertical;

        public OffsetImpl(Offsets.HorizontalOffset horizontal, Offsets.VerticalOffset vertical) {
            this.horizontal = horizontal;
            this.vertical = vertical;
        }

        @Override
        public Offsets.HorizontalOffset horizontal() {
            return this.horizontal;
        }

        @Override
        public Offsets.VerticalOffset vertical() {
            return this.vertical;
        }

        @Override
        public Point apply(Rectangle rectangle) {
            Point offset = this.offset(rectangle.dimension());
            return rectangle.topLeft().moveBy(offset.x(), offset.y());
        }

        @Override
        public Point offset(Dimension size) {
            double x = this.horizontal.apply(size.width());
            double y = this.vertical.apply(size.height());
            return new Point(this.toInt(x), this.toInt(y));
        }

        protected int toInt(double val) {
            if (val == Double.POSITIVE_INFINITY) {
                return Integer.MAX_VALUE;
            }
            if (val == Double.NEGATIVE_INFINITY) {
                return Integer.MIN_VALUE;
            }
            return Math.round((float)val);
        }

        public String toString() {
            return String.format("%s %s", this.horizontal, this.vertical);
        }
    }

    public static class UnitVerticalOffsetImpl
    extends AbstractVerticalOffset
    implements Offsets.UnitVerticalOffset {
        public UnitVerticalOffsetImpl(Offsets.VerticalOffset parent, double val) {
            super(parent, val, Offsets.Unit.PIXEL);
        }

        @Override
        public Offsets.VerticalOffset percent() {
            return new AbstractVerticalOffset(this.parent, this.val, Offsets.Unit.PERCENT);
        }

        @Override
        public Offsets.VerticalOffset pixels() {
            return new AbstractVerticalOffset(this.parent, this.val, Offsets.Unit.PIXEL);
        }
    }

    public static class AbstractVerticalOffset
    implements Offsets.VerticalOffset {
        protected final Offsets.VerticalOffset parent;
        protected final double val;
        protected final Offsets.Unit unit;

        public AbstractVerticalOffset(Offsets.VerticalOffset parent, double val, Offsets.Unit unit) {
            this.parent = parent;
            this.val = val;
            this.unit = unit == null ? Offsets.Unit.PIXEL : unit;
        }

        @Override
        public Offsets.UnitVerticalOffset plus(double val) {
            return new UnitVerticalOffsetImpl(this, val);
        }

        @Override
        public Offsets.VerticalOffset plus(double val, Offsets.Unit unit) {
            return new AbstractVerticalOffset(this, val, unit);
        }

        @Override
        public Offsets.UnitVerticalOffset minus(double val) {
            return this.plus(-val);
        }

        @Override
        public Offsets.VerticalOffset minus(double val, Offsets.Unit unit) {
            return this.plus(-val, unit);
        }

        @Override
        public double apply(double height) {
            double offset;
            double parentOffset = this.parent.apply(height);
            Preconditions.checkState((boolean)Doubles.isFinite((double)parentOffset), (Object)"Parent value cannot be infinite");
            switch (this.unit) {
                case PIXEL: {
                    offset = this.val;
                    break;
                }
                default: {
                    offset = height * this.val / 100.0;
                }
            }
            return parentOffset + offset;
        }

        public String toString() {
            return String.format("%s%s%s", new Object[]{this.parent, DECIMAL_FORMAT.format(this.val), this.unit});
        }
    }

    public static class UnitHorizontalOffsetImpl
    extends AbstractHorizontalOffset
    implements Offsets.UnitHorizontalOffset {
        public UnitHorizontalOffsetImpl(Offsets.HorizontalOffset parent, double val) {
            super(parent, val, Offsets.Unit.PIXEL);
        }

        @Override
        public Offsets.HorizontalOffset percent() {
            return new AbstractHorizontalOffset(this.parent, this.val, Offsets.Unit.PERCENT);
        }

        @Override
        public Offsets.HorizontalOffset pixels() {
            return new AbstractHorizontalOffset(this.parent, this.val, Offsets.Unit.PIXEL);
        }
    }

    public static class AbstractHorizontalOffset
    implements Offsets.HorizontalOffset {
        protected final Offsets.HorizontalOffset parent;
        protected final double val;
        protected final Offsets.Unit unit;

        public AbstractHorizontalOffset(Offsets.HorizontalOffset parent, double val, Offsets.Unit unit) {
            this.parent = parent;
            this.val = val;
            this.unit = unit == null ? Offsets.Unit.PIXEL : unit;
        }

        @Override
        public Offsets.UnitHorizontalOffset plus(double val) {
            return new UnitHorizontalOffsetImpl(this, val);
        }

        @Override
        public Offsets.HorizontalOffset plus(double val, Offsets.Unit unit) {
            return new AbstractHorizontalOffset(this, val, unit);
        }

        @Override
        public Offsets.UnitHorizontalOffset minus(double val) {
            return this.plus(-val);
        }

        @Override
        public Offsets.HorizontalOffset minus(double val, Offsets.Unit unit) {
            return this.plus(-val, unit);
        }

        @Override
        public double apply(double width) {
            double offset;
            double parentOffset = this.parent.apply(width);
            Preconditions.checkState((boolean)Doubles.isFinite((double)parentOffset), (Object)"Parent value cannot be infinite");
            switch (this.unit) {
                case PIXEL: {
                    offset = this.val;
                    break;
                }
                default: {
                    offset = width * this.val / 100.0;
                }
            }
            return parentOffset + offset;
        }

        public String toString() {
            return String.format("%s%s%s", new Object[]{this.parent, DECIMAL_FORMAT.format(this.val), this.unit});
        }
    }
}

