/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.specs;

import io.virtdata.api.ValueType;
import io.virtdata.api.specs.Specifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpecData
implements Specifier {
    public static final String RTYPE_DELIM = "->";
    protected static final Pattern funcNamePattern = Pattern.compile("(?<func>[a-zA-Z][a-zA-Z0-9-_.]*)");
    protected static final Pattern argPattern = Pattern.compile("(\\s*(?<arg>[^,)]+)?\\s*(\\)|,)*)");
    protected static final Pattern argsPattern = Pattern.compile("(?<args>(\\(.*?)\\))?");
    protected static final Pattern resultTypePattern = Pattern.compile("( *-> *(?<rtype>\\w+))?");
    private static final Pattern specPattern = Pattern.compile(funcNamePattern.pattern() + argsPattern.pattern() + resultTypePattern.pattern());
    private String[] funcArgs;
    private ValueType resultType;

    private SpecData(String func, String[] args, ValueType resultType) {
        this.funcArgs = new String[args.length + 1];
        this.funcArgs[0] = func;
        System.arraycopy(args, 0, this.funcArgs, 1, args.length);
        this.resultType = resultType;
    }

    public static SpecData forSpec(String spec) {
        Optional<SpecData> specData = SpecData.forOptionalSpec(spec);
        return specData.orElseThrow(() -> new RuntimeException("Unable to parse " + spec));
    }

    public static Optional<SpecData> forOptionalSpec(String spec) {
        String rtype;
        Matcher matcher = specPattern.matcher(spec);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String funcname = matcher.group("func");
        String funcargs = matcher.group("args");
        ArrayList<String> args = new ArrayList<String>();
        if (funcargs != null) {
            if (funcargs.startsWith("(") && funcargs.endsWith(")")) {
                funcargs = funcargs.substring(1, funcargs.length() - 1);
            }
            Matcher matchargs = argPattern.matcher(funcargs);
            while (matchargs.find()) {
                if (matchargs.group("arg") == null) continue;
                args.add(matchargs.group("arg"));
            }
        }
        ValueType valueType = (rtype = matcher.group("rtype")) == null ? null : ValueType.valueOfClassName(rtype);
        SpecData newspec = new SpecData(funcname, args.toArray(new String[0]), valueType);
        return Optional.of(newspec);
    }

    public SpecData forResultType(ValueType resultType) {
        return new SpecData(this.getFuncName(), this.getArgs(), resultType);
    }

    public String getFuncName() {
        return this.funcArgs[0];
    }

    public String[] getArgs() {
        return Arrays.copyOfRange(this.funcArgs, 1, this.funcArgs.length);
    }

    @Override
    public Optional<ValueType> getResultType() {
        return Optional.ofNullable(this.resultType);
    }

    public String[] getFuncAndArgs() {
        return Arrays.copyOf(this.funcArgs, this.funcArgs.length);
    }

    @Override
    public String getCanonicalSpec() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getFuncName());
        if (this.funcArgs.length > 0) {
            sb.append("(");
            String comma = "";
            for (String funcArg : this.getArgs()) {
                sb.append(comma).append(funcArg);
                comma = ",";
            }
            sb.append(")");
        }
        if (this.resultType != null) {
            sb.append(RTYPE_DELIM).append(this.resultType.getSimpleName());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCanonicalSpec();
    }
}

