/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.composers.ComposerForDoubleFunction;
import io.virtdata.api.composers.ComposerForDoubleToLongFunction;
import io.virtdata.api.composers.ComposerForDoubleUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForDoubleToIntFunction
implements FunctionComposer<DoubleToIntFunction> {
    private final DoubleToIntFunction inner;

    public ComposerForDoubleToIntFunction(DoubleToIntFunction inner) {
        this.inner = inner;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer andThen(Object outer) {
        FunctionType functionType = FunctionType.valueOf(outer);
        switch (functionType) {
            case long_long: {
                DoubleToLongFunction f1 = d -> ((LongUnaryOperator)outer).applyAsLong(this.inner.applyAsInt(d));
                return new ComposerForDoubleToLongFunction(f1);
            }
            case long_int: {
                DoubleToIntFunction f2 = d -> ((LongToIntFunction)outer).applyAsInt(this.inner.applyAsInt(d));
                return new ComposerForDoubleToIntFunction(f2);
            }
            case long_double: {
                DoubleUnaryOperator f3 = d -> ((LongToDoubleFunction)outer).applyAsDouble(this.inner.applyAsInt(d));
                return new ComposerForDoubleUnaryOperator(f3);
            }
            case long_T: {
                DoubleFunction<Object> f4 = d -> ((LongFunction)outer).apply(this.inner.applyAsInt(d));
                return new ComposerForDoubleFunction(f4);
            }
            case int_int: {
                DoubleToIntFunction f5 = d -> ((IntUnaryOperator)outer).applyAsInt(this.inner.applyAsInt(d));
                return new ComposerForDoubleToIntFunction(f5);
            }
            case int_long: {
                DoubleToLongFunction f6 = d -> ((IntToLongFunction)outer).applyAsLong(this.inner.applyAsInt(d));
                return new ComposerForDoubleToLongFunction(f6);
            }
            case int_double: {
                DoubleUnaryOperator f7 = d -> ((IntToDoubleFunction)outer).applyAsDouble(this.inner.applyAsInt(d));
                return new ComposerForDoubleUnaryOperator(f7);
            }
            case int_T: {
                DoubleFunction<Object> f8 = d -> ((IntFunction)outer).apply(this.inner.applyAsInt(d));
                return new ComposerForDoubleFunction(f8);
            }
            case double_double: {
                DoubleUnaryOperator f9 = d -> ((DoubleUnaryOperator)outer).applyAsDouble(this.inner.applyAsInt(d));
                return new ComposerForDoubleUnaryOperator(f9);
            }
            case double_long: {
                DoubleToLongFunction f10 = d -> ((DoubleToLongFunction)outer).applyAsLong(this.inner.applyAsInt(d));
                return new ComposerForDoubleToLongFunction(f10);
            }
            case double_int: {
                DoubleToIntFunction f11 = d -> ((DoubleToIntFunction)outer).applyAsInt(this.inner.applyAsInt(d));
                return new ComposerForDoubleToIntFunction(f11);
            }
            case double_T: {
                DoubleFunction<Object> f12 = d -> ((DoubleFunction)outer).apply(this.inner.applyAsInt(d));
                return new ComposerForDoubleFunction(f12);
            }
            case R_T: {
                DoubleFunction<Object> f13 = d -> ((Function)outer).apply(this.inner.applyAsInt(d));
                return new ComposerForDoubleFunction(f13);
            }
        }
        throw new RuntimeException("Unrecognized function type:" + functionType);
    }
}

