/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.api.ValueType;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.core.BindingsTemplate;
import io.virtdata.core.CompatibilityFixups;
import io.virtdata.core.DataMapperFunctionMapper;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.core.VirtDataComposer;
import io.virtdata.parser.VirtDataDSL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtData {
    private static final Logger logger = LoggerFactory.getLogger(VirtData.class);

    public static BindingsTemplate getTemplate(String ... namesAndSpecs) {
        if (namesAndSpecs.length % 2 != 0) {
            throw new RuntimeException("args must be in 'name','spec', pairs. This can't be true for " + namesAndSpecs.length + "elements.");
        }
        HashMap<String, String> specmap = new HashMap<String, String>();
        for (int i = 0; i < namesAndSpecs.length; i += 2) {
            specmap.put(namesAndSpecs[i], namesAndSpecs[i + 1]);
        }
        return VirtData.getTemplate(specmap);
    }

    public static BindingsTemplate getTemplate(Map<String, String> namedBindings) {
        for (String bindingSpec : namedBindings.values()) {
            VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)bindingSpec);
            if (parseResult.throwable == null) continue;
            throw new RuntimeException(parseResult.throwable);
        }
        return new BindingsTemplate(namedBindings);
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String flowSpec) {
        flowSpec = CompatibilityFixups.fixup(flowSpec);
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)flowSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        VirtDataComposer composer = new VirtDataComposer();
        Optional<ResolvedFunction> resolvedFunction = composer.resolveFunctionFlow(flow);
        return resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String flowSpec, Class<? extends T> clazz) {
        Object actualTestValue;
        VirtDataComposer composer;
        Optional<ResolvedFunction> resolvedFunction;
        Optional<DataMapper<T>> mapper;
        flowSpec = CompatibilityFixups.fixup(flowSpec);
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse((String)flowSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        String outputType = flow.getLastExpression().getCall().getOutputType();
        Class<?> outputClass = ValueType.classOfType(outputType);
        if (outputClass != null) {
            if (!ClassUtils.isAssignable(outputClass, clazz, (boolean)true)) {
                throw new RuntimeException("The flow specifier '" + flowSpec + "' wants an output type of '" + outputType + "', but this type is not assignable to the explicit class '" + clazz.getCanonicalName() + "' that was enforced at the API level. Either remove the output type qualifier at the last function in the flow spec, or change it to something that can reliably be cast to type '" + clazz.getCanonicalName() + "'");
            }
        } else {
            logger.debug("Auto-assigning output type qualifier '->" + clazz.getCanonicalName() + "' to specifier '" + flowSpec + "'");
            flow.getLastExpression().getCall().setOutputType(clazz.getCanonicalName());
        }
        if ((mapper = (resolvedFunction = (composer = new VirtDataComposer()).resolveFunctionFlow(flow)).map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map)).isPresent() && !ClassUtils.isAssignable((actualTestValue = mapper.get().get(1L)).getClass(), clazz, (boolean)true)) {
            throw new RuntimeException("The flow specifier '" + flowSpec + "' successfully created a function, but the test value(" + String.valueOf(actualTestValue) + ") of type [" + actualTestValue.getClass() + "] produced by it was not assignable to the type '" + clazz.getCanonicalName() + "' which was explicitly set at the API level.");
        }
        return mapper;
    }

    public static <T> DataMapper<T> getMapper(String flowSpec) {
        Optional<DataMapper<T>> optionalMapper = VirtData.getOptionalMapper(flowSpec);
        return optionalMapper.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + flowSpec));
    }

    public static <T> DataMapper<T> getMapper(String flowSpec, Class<? extends T> clazz) {
        Optional<DataMapper<T>> dataMapper = VirtData.getOptionalMapper(flowSpec, clazz);
        DataMapper<? extends T> mapper = dataMapper.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + flowSpec));
        return mapper;
    }
}

