/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.reflection;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public class DeferredConstructor<T> {
    private Class<T> classToConstruct;
    private Object[] args;

    public DeferredConstructor(Class<T> classToConstruct, Object ... args) {
        this.classToConstruct = classToConstruct;
        this.args = args;
    }

    public DeferredConstructor<T> prefixArgs(Object ... prefixArgs) {
        Object[] fullArgs = new Object[prefixArgs.length + this.args.length];
        System.arraycopy(prefixArgs, 0, fullArgs, 0, prefixArgs.length);
        System.arraycopy(this.args, 0, fullArgs, prefixArgs.length, this.args.length);
        return new DeferredConstructor<T>(this.classToConstruct, fullArgs);
    }

    public T construct() {
        Object constructed = null;
        try {
            constructed = ConstructorUtils.invokeConstructor(this.classToConstruct, (Object[])this.args);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking constructor for:" + this.toString());
        }
        return (T)constructed;
    }

    public String toString() {
        return "class:" + this.classToConstruct.getName() + ", args:" + Arrays.stream(this.args).map(String::valueOf).collect(Collectors.joining("[", ",", "]"));
    }

    public void validate() {
        try {
            this.construct();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while validating DeferredConstructor for " + this.toString(), e);
        }
    }
}

