/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api;

import io.virtdata.api.DataMapper;
import io.virtdata.core.DataMapperFunctionMapper;
import io.virtdata.core.ResolvedFunction;
import java.util.List;
import java.util.Optional;

public interface DataMapperLibrary {
    public String getLibraryName();

    default public <T> Optional<DataMapper<T>> getDataMapper(String string) {
        if (this.canParseSpec(string)) {
            Optional<ResolvedFunction> optional = this.resolveFunction(string);
            return optional.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        }
        return Optional.empty();
    }

    default public <T> Optional<DataMapper<T>> getOptionalDataMapper(String string, Class<? extends T> clazz) {
        return Optional.ofNullable(this.getDataMapper(string, clazz));
    }

    default public <T> DataMapper<T> getDataMapper(String string, Class<? extends T> clazz) {
        if (!this.canParseSpec(string)) {
            return null;
        }
        Optional<ResolvedFunction> optional = this.resolveFunction(string);
        if (!optional.isPresent()) {
            return null;
        }
        ResolvedFunction resolvedFunction = optional.get();
        DataMapper dataMapper = DataMapperFunctionMapper.map(resolvedFunction.getFunctionObject());
        return dataMapper;
    }

    public boolean canParseSpec(String var1);

    public Optional<ResolvedFunction> resolveFunction(String var1);

    public List<ResolvedFunction> resolveFunctions(String var1);

    public List<String> getDataMapperNames();

    default public Optional<DataMapper<Long>> getLongDataMapper(String string) {
        if (!this.canParseSpec(string)) {
            return Optional.empty();
        }
        Optional<ResolvedFunction> optional = this.resolveFunction(string);
        Optional<DataMapper<Long>> optional2 = optional.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return optional2;
    }

    default public Optional<DataMapper<Double>> getDoubleDataMapper(String string) {
        if (!this.canParseSpec(string)) {
            return Optional.empty();
        }
        Optional<ResolvedFunction> optional = this.resolveFunction(string);
        Optional<DataMapper<Double>> optional2 = optional.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return optional2;
    }

    default public Optional<DataMapper<Integer>> getIntegerDataMapper(String string) {
        if (!this.canParseSpec(string)) {
            return Optional.empty();
        }
        Optional<ResolvedFunction> optional = this.resolveFunction(string);
        Optional<DataMapper<Integer>> optional2 = optional.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return optional2;
    }

    default public Optional<DataMapper<String>> getStringDataMapper(String string) {
        if (!this.canParseSpec(string)) {
            return Optional.empty();
        }
        Optional<ResolvedFunction> optional = this.resolveFunction(string);
        Optional<DataMapper<String>> optional2 = optional.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return optional2;
    }
}

