/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.composers.ComposerForDoubleFunction;
import io.virtdata.api.composers.ComposerForDoubleToLongFunction;
import io.virtdata.api.composers.ComposerForDoubleUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForDoubleToIntFunction
implements FunctionComposer<DoubleToIntFunction> {
    private final DoubleToIntFunction inner;

    public ComposerForDoubleToIntFunction(DoubleToIntFunction doubleToIntFunction) {
        this.inner = doubleToIntFunction;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer andThen(Object object) {
        FunctionType functionType = FunctionType.valueOf(object);
        switch (functionType) {
            case long_long: {
                DoubleToLongFunction doubleToLongFunction = d -> ((LongUnaryOperator)object).applyAsLong(this.inner.applyAsInt(d));
                return new ComposerForDoubleToLongFunction(doubleToLongFunction);
            }
            case long_int: {
                DoubleToIntFunction doubleToIntFunction = d -> ((LongToIntFunction)object).applyAsInt(this.inner.applyAsInt(d));
                return new ComposerForDoubleToIntFunction(doubleToIntFunction);
            }
            case long_double: {
                DoubleUnaryOperator doubleUnaryOperator = d -> ((LongToDoubleFunction)object).applyAsDouble(this.inner.applyAsInt(d));
                return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
            }
            case long_T: {
                DoubleFunction<Object> doubleFunction = d -> ((LongFunction)object).apply(this.inner.applyAsInt(d));
                return new ComposerForDoubleFunction(doubleFunction);
            }
            case int_int: {
                DoubleToIntFunction doubleToIntFunction = d -> ((IntUnaryOperator)object).applyAsInt(this.inner.applyAsInt(d));
                return new ComposerForDoubleToIntFunction(doubleToIntFunction);
            }
            case int_long: {
                DoubleToLongFunction doubleToLongFunction = d -> ((IntToLongFunction)object).applyAsLong(this.inner.applyAsInt(d));
                return new ComposerForDoubleToLongFunction(doubleToLongFunction);
            }
            case int_double: {
                DoubleUnaryOperator doubleUnaryOperator = d -> ((IntToDoubleFunction)object).applyAsDouble(this.inner.applyAsInt(d));
                return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
            }
            case int_T: {
                DoubleFunction<Object> doubleFunction = d -> ((IntFunction)object).apply(this.inner.applyAsInt(d));
                return new ComposerForDoubleFunction(doubleFunction);
            }
            case double_double: {
                DoubleUnaryOperator doubleUnaryOperator = d -> ((DoubleUnaryOperator)object).applyAsDouble(this.inner.applyAsInt(d));
                return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
            }
            case double_long: {
                DoubleToLongFunction doubleToLongFunction = d -> ((DoubleToLongFunction)object).applyAsLong(this.inner.applyAsInt(d));
                return new ComposerForDoubleToLongFunction(doubleToLongFunction);
            }
            case double_int: {
                DoubleToIntFunction doubleToIntFunction = d -> ((DoubleToIntFunction)object).applyAsInt(this.inner.applyAsInt(d));
                return new ComposerForDoubleToIntFunction(doubleToIntFunction);
            }
            case double_T: {
                DoubleFunction<Object> doubleFunction = d -> ((DoubleFunction)object).apply(this.inner.applyAsInt(d));
                return new ComposerForDoubleFunction(doubleFunction);
            }
            case R_T: {
                DoubleFunction<Object> doubleFunction = d -> ((Function)object).apply(this.inner.applyAsInt(d));
                return new ComposerForDoubleFunction(doubleFunction);
            }
        }
        throw new RuntimeException("Unrecognized function type:" + functionType);
    }
}

