/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.api.FunctionType;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class DataMapperFunctionMapper {
    public static <T> DataMapper<T> map(Object object) {
        FunctionType functionType = FunctionType.valueOf(object);
        switch (functionType) {
            case long_double: {
                return DataMapperFunctionMapper.map((LongToDoubleFunction)object);
            }
            case long_int: {
                return DataMapperFunctionMapper.map((LongToIntFunction)object);
            }
            case long_long: {
                return DataMapperFunctionMapper.map((LongUnaryOperator)object);
            }
            case long_T: {
                return DataMapperFunctionMapper.map((LongFunction)object);
            }
            case R_T: {
                return DataMapperFunctionMapper.map((Function)object);
            }
            case int_int: {
                return DataMapperFunctionMapper.map((IntUnaryOperator)object);
            }
            case int_long: {
                return DataMapperFunctionMapper.map((IntToLongFunction)object);
            }
            case int_double: {
                return DataMapperFunctionMapper.map((IntToDoubleFunction)object);
            }
            case int_T: {
                return DataMapperFunctionMapper.map((IntFunction)object);
            }
            case double_double: {
                return DataMapperFunctionMapper.map((DoubleUnaryOperator)object);
            }
            case double_long: {
                return DataMapperFunctionMapper.map((DoubleToLongFunction)object);
            }
            case double_int: {
                return DataMapperFunctionMapper.map((DoubleToIntFunction)object);
            }
            case double_T: {
                return DataMapperFunctionMapper.map((DoubleFunction)object);
            }
        }
        throw new RuntimeException("Function object was not a recognized type for mapping to a data mapping lambda: " + object.toString());
    }

    public static <R> DataMapper<R> map(DoubleFunction<R> doubleFunction) {
        return l -> doubleFunction.apply(l);
    }

    public static DataMapper<Integer> map(DoubleToIntFunction doubleToIntFunction) {
        return doubleToIntFunction::applyAsInt;
    }

    public static DataMapper<Long> map(DoubleToLongFunction doubleToLongFunction) {
        return doubleToLongFunction::applyAsLong;
    }

    public static DataMapper<Double> map(DoubleUnaryOperator doubleUnaryOperator) {
        return doubleUnaryOperator::applyAsDouble;
    }

    public static <R> DataMapper<R> map(IntFunction<R> intFunction) {
        return l -> intFunction.apply((int)l);
    }

    public static DataMapper<Long> map(IntToDoubleFunction intToDoubleFunction) {
        return l -> (long)intToDoubleFunction.applyAsDouble((int)l);
    }

    public static DataMapper<Long> map(IntToLongFunction intToLongFunction) {
        return l -> intToLongFunction.applyAsLong((int)l);
    }

    public static DataMapper<Integer> map(IntUnaryOperator intUnaryOperator) {
        return l -> intUnaryOperator.applyAsInt((int)l);
    }

    public static DataMapper<Double> map(LongToDoubleFunction longToDoubleFunction) {
        return longToDoubleFunction::applyAsDouble;
    }

    public static DataMapper<Integer> map(LongToIntFunction longToIntFunction) {
        return longToIntFunction::applyAsInt;
    }

    public static DataMapper<Long> map(LongUnaryOperator longUnaryOperator) {
        return longUnaryOperator::applyAsLong;
    }

    public static <R> DataMapper<R> map(LongFunction<R> longFunction) {
        return longFunction::apply;
    }

    public static <R> DataMapper<R> map(Function<Long, R> function) {
        return function::apply;
    }
}

