/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.templates;

import io.virtdata.api.ValuesBinder;
import io.virtdata.core.Bindings;
import io.virtdata.templates.ParsedTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class StringCompositor
implements ValuesBinder<StringCompositor, String> {
    private String[] templateSegments;
    private Function<Object, String> stringfunc = String::valueOf;

    public StringCompositor(String string) {
        this.templateSegments = this.parseTemplate(string);
    }

    public StringCompositor(String string, Function<Object, String> function) {
        this(string);
        this.stringfunc = function;
    }

    protected String[] parseTemplate(String string) {
        ParsedTemplate parsedTemplate = new ParsedTemplate(string, Collections.emptyMap());
        return parsedTemplate.getSpans();
    }

    @Override
    public String bindValues(StringCompositor stringCompositor, Bindings bindings, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.templateSegments.length; ++i) {
            if (i % 2 == 0) {
                stringBuilder.append(this.templateSegments[i]);
                continue;
            }
            String string = this.templateSegments[i];
            Object object = bindings.get(string, l);
            String string2 = this.stringfunc.apply(object);
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public List<String> getBindPointNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.templateSegments.length; ++i) {
            if (i % 2 != 1) continue;
            arrayList.add(this.templateSegments[i]);
        }
        return arrayList;
    }
}

