/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class StringObjectPromoter {
    public static Object promote(String string, Class<?> clazz) {
        try {
            if (clazz == String.class) {
                return string.matches("^'.+'$") ? string.substring(1, string.length() - 1) : string;
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                Double d = Double.valueOf(string);
                return clazz.isPrimitive() ? d.doubleValue() : d.doubleValue();
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                Float f = Float.valueOf(string);
                return Float.valueOf(clazz.isPrimitive() ? f.floatValue() : f.floatValue());
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                Long l = Long.valueOf(string);
                return clazz.isPrimitive() ? l.longValue() : l.longValue();
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                Integer n = Integer.valueOf(string);
                return clazz.isPrimitive() ? n.intValue() : n.intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static Object promote(String string) {
        if (string.matches("^'.*'$")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.matches("^\\d+\\.\\d+(E\\d+)?[dD]$")) {
            try {
                Double d = Double.valueOf(string);
                return d;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.matches("^\\d+\\.\\d+(E\\d+)?[fF]$")) {
            try {
                Float f = Float.valueOf(string.substring(0, string.length() - 1));
                return f;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.matches("^\\d+\\.\\d+(E\\d+)?$")) {
            Number number;
            try {
                number = Float.valueOf(string);
                if (!Float.isInfinite(((Float)number).floatValue())) {
                    return number;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                number = Double.valueOf(string);
                if (!((Double)number).isInfinite()) {
                    return number;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                number = new BigDecimal(string);
                return number;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.matches("^\\d+[lL]$")) {
            try {
                Long l = Long.valueOf(string.substring(0, string.length() - 1));
                return l;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.matches("^\\d+$")) {
            try {
                Integer n = Integer.valueOf(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Long l = Long.valueOf(string);
                    return l;
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        BigInteger bigInteger = new BigInteger(string);
                        return bigInteger;
                    }
                    catch (NumberFormatException numberFormatException3) {}
                }
            }
        } else if (string.equals("true")) {
            return true;
        }
        return string;
    }

    public static boolean isAssignableForConstructor(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz2 == Boolean.TYPE && clazz == Boolean.class || clazz2 == Byte.TYPE && clazz == Byte.class || clazz2 == Short.TYPE && clazz == Short.class || clazz2 == Character.TYPE && clazz == Character.class || clazz2 == Integer.TYPE && clazz == Integer.class || clazz2 == Long.TYPE && clazz == Long.class || clazz2 == Float.TYPE && clazz == Float.class || clazz2 == Double.TYPE && clazz == Double.class;
    }
}

