/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.util;

import java.lang.reflect.TypeVariable;
import java.security.InvalidParameterException;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import org.apache.commons.lang3.ClassUtils;

public class VirtDataFunctions {
    public static <F> F adapt(Object object, Class<F> clazz, Class<?> clazz2, boolean bl) {
        FuncType funcType = FuncType.valueOf(clazz);
        switch (funcType) {
            case LongUnaryOperator: {
                return (F)(bl ? VirtDataFunctions.adaptLongUnaryOperator(object, clazz2) : VirtDataFunctions.adaptLongUnaryOperatorStrict(object, clazz2));
            }
            case DoubleUnaryOperator: {
                return bl ? VirtDataFunctions.adaptDoubleUnaryOperator(object, clazz2) : VirtDataFunctions.adaptDoubleUnaryOperatorStrict(object, clazz2);
            }
            case IntUnaryOperator: {
                return bl ? VirtDataFunctions.adaptIntUnaryOperator(object, clazz2) : VirtDataFunctions.adaptIntUnaryOperatorStrict(object, clazz2);
            }
            case DoubleFunction: {
                return bl ? VirtDataFunctions.adaptDoubleFunction(object, clazz2) : VirtDataFunctions.adaptDoubleFunctionStrict(object, clazz2);
            }
            case LongFunction: {
                return (F)(bl ? VirtDataFunctions.adaptLongFunction(object, clazz2) : VirtDataFunctions.adaptLongFunctionStrict(object, clazz2));
            }
            case IntFunction: {
                return bl ? VirtDataFunctions.adaptIntFunction(object, clazz2) : VirtDataFunctions.adaptIntFunction(object, clazz2);
            }
            case Function: {
                return (F)(bl ? VirtDataFunctions.adaptFunction(object, clazz2) : VirtDataFunctions.adaptFunctionStrict(object, clazz2));
            }
        }
        throw new RuntimeException("Unable to convert " + object.getClass().getCanonicalName() + " to " + clazz.getCanonicalName() + (bl ? " WITH " : " WITHOUT ") + "truncation");
    }

    private static LongFunction<?> adaptLongFunctionStrict(Object object, Class<?> clazz) {
        FuncType funcType = FuncType.valueOf(object.getClass());
        switch (funcType) {
            case LongFunction: {
                LongFunction longFunction = VirtDataFunctions.assertTypesAssignable(object, LongFunction.class, Object.class);
                return longFunction;
            }
            case LongUnaryOperator: {
                LongUnaryOperator longUnaryOperator = VirtDataFunctions.assertTypesAssignable(object, LongUnaryOperator.class, new Class[0]);
                return longUnaryOperator::applyAsLong;
            }
            case Function: {
                Function function = VirtDataFunctions.assertTypesAssignable(object, Function.class, Long.class);
                return l -> function.apply(l);
            }
        }
        throw new RuntimeException("Unable to convert " + object.getClass().getCanonicalName() + " to a " + LongUnaryOperator.class.getCanonicalName() + " since this would cause a narrowing conversion.");
    }

    private static Function<?, ?> adaptFunction(Object object, Class<?> clazz) {
        FuncType funcType = FuncType.valueOf(object.getClass());
        switch (funcType) {
            case LongFunction: {
                LongFunction longFunction = (LongFunction)object;
                Function<Long, Object> function = longFunction::apply;
                return function;
            }
            case LongUnaryOperator: {
                LongUnaryOperator longUnaryOperator = (LongUnaryOperator)object;
                Function<Long, Long> function = longUnaryOperator::applyAsLong;
                return function;
            }
            case IntFunction: {
                IntFunction intFunction = (IntFunction)object;
                Function<Integer, Object> function = intFunction::apply;
                return function;
            }
            case IntUnaryOperator: {
                IntUnaryOperator intUnaryOperator = (IntUnaryOperator)object;
                Function<Integer, Object> function = intUnaryOperator::applyAsInt;
                return function;
            }
            case DoubleFunction: {
                DoubleFunction doubleFunction = (DoubleFunction)object;
                Function<Double, Object> function = doubleFunction::apply;
                return function;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator doubleUnaryOperator = (DoubleUnaryOperator)object;
                Function<Double, Object> function = doubleUnaryOperator::applyAsDouble;
                return function;
            }
            case Function: {
                return (Function)object;
            }
        }
        throw new RuntimeException("Unable to map function:" + object);
    }

    private static <F> F adaptFunctionStrict(Object object, Class<?> clazz) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptDoubleFunctionStrict(Object object, Class<?> clazz) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptIntUnaryOperatorStrict(Object object, Class<?> clazz) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptDoubleUnaryOperatorStrict(Object object, Class<?> clazz) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static LongUnaryOperator adaptLongUnaryOperatorStrict(Object object, Class<?> clazz) {
        FuncType funcType = FuncType.valueOf(object.getClass());
        switch (funcType) {
            case LongFunction: {
                LongFunction longFunction = VirtDataFunctions.assertTypesAssignable(object, LongFunction.class, Long.TYPE);
                return longFunction::apply;
            }
            case LongUnaryOperator: {
                LongUnaryOperator longUnaryOperator = VirtDataFunctions.assertTypesAssignable(object, LongUnaryOperator.class, new Class[0]);
                return longUnaryOperator;
            }
            case Function: {
                Function function = VirtDataFunctions.assertTypesAssignable(object, Function.class, Long.TYPE, Long.TYPE);
                return function::apply;
            }
        }
        throw new RuntimeException("Unable to convert " + object.getClass().getCanonicalName() + " to a " + LongUnaryOperator.class.getCanonicalName() + " since this would cause a narrowing conversion.");
    }

    private static <F> F adaptIntFunction(Object object, Class<?> clazz) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static LongFunction<?> adaptLongFunction(Object object, Class<?> clazz) {
        FuncType funcType = FuncType.valueOf(object.getClass());
        switch (funcType) {
            case LongFunction: {
                LongFunction longFunction = VirtDataFunctions.assertTypesAssignable(object, LongFunction.class, Object.class);
                return longFunction;
            }
            case LongUnaryOperator: {
                LongUnaryOperator longUnaryOperator = VirtDataFunctions.assertTypesAssignable(object, LongUnaryOperator.class, new Class[0]);
                return longUnaryOperator::applyAsLong;
            }
            case IntFunction: {
                IntFunction intFunction = VirtDataFunctions.assertTypesAssignable(object, IntFunction.class, new Class[0]);
                return l -> intFunction.apply((int)(l % Integer.MAX_VALUE));
            }
            case IntUnaryOperator: {
                IntUnaryOperator intUnaryOperator = VirtDataFunctions.assertTypesAssignable(object, IntUnaryOperator.class, new Class[0]);
                return l -> intUnaryOperator.applyAsInt((int)(l % Integer.MAX_VALUE));
            }
            case DoubleFunction: {
                DoubleFunction doubleFunction = VirtDataFunctions.assertTypesAssignable(object, DoubleFunction.class, new Class[0]);
                return doubleFunction::apply;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator doubleUnaryOperator = VirtDataFunctions.assertTypesAssignable(object, DoubleUnaryOperator.class, new Class[0]);
                return doubleUnaryOperator::applyAsDouble;
            }
            case Function: {
                Function function = VirtDataFunctions.assertTypesAssignable(object, Function.class, new Class[0]);
                VirtDataFunctions.assertOutputAssignable(function.apply(1L), clazz);
                return l -> function.apply(l);
            }
        }
        throw new RuntimeException("Unable to convert " + object.getClass().getCanonicalName() + " to a " + LongUnaryOperator.class.getCanonicalName());
    }

    private static void assertOutputAssignable(Object object, Class<?> clazz) {
        if (!ClassUtils.isAssignable(object.getClass(), clazz, (boolean)true)) {
            throw new InvalidParameterException("Unable to assign type of " + object.getClass().getCanonicalName() + " to " + clazz.getCanonicalName());
        }
    }

    private static <F> F adaptDoubleFunction(Object object, Class<?> clazz) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptIntUnaryOperator(Object object, Class<?> clazz) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static <F> F adaptDoubleUnaryOperator(Object object, Class<?> clazz) {
        throw new RuntimeException("This must be implemented, now that it is used.");
    }

    private static LongUnaryOperator adaptLongUnaryOperator(Object object, Class<?> clazz) {
        FuncType funcType = FuncType.valueOf(object.getClass());
        switch (funcType) {
            case IntFunction: {
                IntFunction intFunction = VirtDataFunctions.assertTypesAssignable(object, IntFunction.class, Long.TYPE);
                return l -> (Long)intFunction.apply((int)l % Integer.MAX_VALUE);
            }
            case LongFunction: {
                LongFunction longFunction = VirtDataFunctions.assertTypesAssignable(object, LongFunction.class, Long.TYPE);
                return longFunction::apply;
            }
            case DoubleFunction: {
                DoubleFunction doubleFunction = VirtDataFunctions.assertTypesAssignable(object, DoubleFunction.class, Long.TYPE);
                return doubleFunction::apply;
            }
            case IntUnaryOperator: {
                IntUnaryOperator intUnaryOperator = VirtDataFunctions.assertTypesAssignable(object, IntUnaryOperator.class, new Class[0]);
                return l -> intUnaryOperator.applyAsInt((int)l % Integer.MAX_VALUE);
            }
            case LongUnaryOperator: {
                LongUnaryOperator longUnaryOperator = VirtDataFunctions.assertTypesAssignable(object, LongUnaryOperator.class, new Class[0]);
                return longUnaryOperator;
            }
            case DoubleUnaryOperator: {
                DoubleUnaryOperator doubleUnaryOperator = VirtDataFunctions.assertTypesAssignable(object, DoubleUnaryOperator.class, new Class[0]);
                return l -> (long)(doubleUnaryOperator.applyAsDouble(l) % 9.223372036854776E18);
            }
            case Function: {
                Function function = VirtDataFunctions.assertTypesAssignable(object, Function.class, Long.TYPE, Long.TYPE);
                return function::apply;
            }
        }
        throw new InvalidParameterException("Unable to convert " + object.getClass().getCanonicalName() + " to a " + LongUnaryOperator.class.getCanonicalName());
    }

    private static <T> T assertTypesAssignable(Object object, Class<T> clazz, Class<?> ... classArray) {
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new InvalidParameterException("Unable to assign " + clazz.getCanonicalName() + " from " + object.getClass().getCanonicalName());
        }
        TypeVariable<Class<?>>[] typeVariableArray = object.getClass().getTypeParameters();
        if (typeVariableArray.length > 0) {
            if (classArray.length != typeVariableArray.length) {
                throw new InvalidParameterException("type parameter lengths are mismatched:" + classArray.length + ", " + typeVariableArray.length);
            }
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                TypeVariable<Class<?>> typeVariable = typeVariableArray[i];
                boolean bl = typeVariable.getGenericDeclaration().isAssignableFrom(clazz2);
                if (bl) continue;
                throw new InvalidParameterException("Can not assign " + clazz2.getCanonicalName() + " to " + typeVariable.getGenericDeclaration().getCanonicalName());
            }
        }
        return (T)object;
    }

    private static enum FuncType {
        LongFunction(LongFunction.class, Long.TYPE),
        LongUnaryOperator(LongUnaryOperator.class, Long.TYPE),
        IntFunction(IntFunction.class, Integer.TYPE),
        IntUnaryOperator(IntUnaryOperator.class, Integer.TYPE),
        DoubleFunction(DoubleFunction.class, Double.TYPE),
        DoubleUnaryOperator(DoubleUnaryOperator.class, Double.TYPE),
        Function(Function.class, Object.class);

        private final Class<?> functionClazz;
        private final Class<?> inputClazz;

        private FuncType(Class clazz, Class<?> clazz2) {
            this.functionClazz = clazz;
            this.inputClazz = clazz2;
        }

        public static FuncType valueOf(Class<?> clazz) {
            for (FuncType funcType : FuncType.values()) {
                if (!funcType.functionClazz.isAssignableFrom(clazz)) continue;
                return funcType;
            }
            throw new InvalidParameterException("No func type was found for " + clazz.getCanonicalName());
        }
    }
}

