/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.ast;

import io.virtdata.ast.ArgType;
import io.virtdata.ast.DoubleArg;
import io.virtdata.ast.FloatArg;
import io.virtdata.ast.IntegerArg;
import io.virtdata.ast.LongArg;
import io.virtdata.ast.RefArg;
import io.virtdata.ast.StringArg;
import io.virtdata.ast.VariableRef;
import java.util.ArrayList;
import java.util.List;

public class FunctionCall
implements ArgType {
    private String funcName;
    private List<ArgType> args = new ArrayList<ArgType>();
    private String inputType;
    private String outputType;
    private String inputClass;

    public FunctionCall() {
    }

    public FunctionCall(String funcName) {
        this.funcName = funcName;
    }

    public FunctionCall(String inputType, String funcName) {
        this.inputType = inputType;
        this.funcName = funcName;
    }

    public void addFunctionArg(ArgType argType) {
        this.args.add(argType);
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.inputType == null ? "" : this.inputType + "->");
        sb.append(this.funcName);
        sb.append("(");
        String sep = "";
        for (ArgType arg : this.args) {
            sb.append(sep);
            sb.append(arg);
            sep = ",";
        }
        sb.append(")");
        sb.append(this.outputType == null ? "" : "->" + this.outputType);
        return sb.toString();
    }

    public FunctionCall getVirtdataCall(int i) {
        return (FunctionCall)this.args.get(i);
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public List<ArgType> getArgs() {
        return this.args;
    }

    public Object[] getArguments() {
        ArrayList<Object> args = new ArrayList<Object>();
        block9: for (ArgType argType : this.getArgs()) {
            ArgType.TypeName typeName = ArgType.TypeName.valueOf(argType);
            switch (typeName) {
                case RefArg: {
                    args.add(new VariableRef(((RefArg)argType).getRefName()));
                    continue block9;
                }
                case FunctionCall: {
                    args.add(argType);
                    continue block9;
                }
                case StringArg: {
                    args.add(((StringArg)argType).getStringValue());
                    continue block9;
                }
                case FloatArg: {
                    args.add(((FloatArg)argType).getFloatValue());
                    continue block9;
                }
                case IntegerArg: {
                    args.add(((IntegerArg)argType).getIntValue());
                    continue block9;
                }
                case LongArg: {
                    args.add(((LongArg)argType).getLongValue());
                    continue block9;
                }
                case DoubleArg: {
                    args.add(((DoubleArg)argType).getDoubleValue());
                    continue block9;
                }
            }
            throw new RuntimeException("Could not map type into argument object: " + (Object)((Object)typeName));
        }
        return args.toArray();
    }

    public String getInputClass() {
        return this.inputClass;
    }
}

