/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.api.VirtDataFunctionLibrary;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.core.BindingsTemplate;
import io.virtdata.core.DataMapperFunctionMapper;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.core.VirtDataComposer;
import io.virtdata.parser.VirtDataDSL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface VirtDataLibrary {
    public VirtDataFunctionLibrary getFunctionLibrary();

    public String getLibname();

    default public BindingsTemplate getBindingsTemplate(String ... namesAndSpecs) {
        if (namesAndSpecs.length % 2 != 0) {
            throw new RuntimeException("args must be in 'name','spec', pairs. This can't be true for " + namesAndSpecs.length + "elements.");
        }
        HashMap<String, String> specmap = new HashMap<String, String>();
        for (int i = 0; i < namesAndSpecs.length; i += 2) {
            specmap.put(namesAndSpecs[i], namesAndSpecs[i + 1]);
        }
        return this.getBindingsTemplate(specmap);
    }

    default public <T> Optional<DataMapper<T>> getDataMapper(String flowSpec) {
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse(flowSpec);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow flow = parseResult.flow;
        VirtDataComposer composer = new VirtDataComposer();
        Optional<ResolvedFunction> resolvedFunction = composer.resolveFunctionFlow(flow);
        return resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
    }

    default public BindingsTemplate getBindingsTemplate(Map<String, String> namedBindings) {
        for (String bindingSpec : namedBindings.values()) {
            VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse(bindingSpec);
            if (parseResult.throwable == null) continue;
            throw new RuntimeException(parseResult.throwable);
        }
        return new BindingsTemplate(this, namedBindings);
    }

    default public <T> DataMapper<T> getDataMapper(String s, Class<? extends T> clazz) {
        Optional<DataMapper<T>> dataMapper = this.getDataMapper(s);
        return dataMapper.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + s));
    }
}

