/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_int;

import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
public class CycleRange
implements LongToIntFunction {
    private final long minValue;
    private final long width;

    public CycleRange(long maxValue) {
        this(0L, maxValue);
    }

    public CycleRange(long minValue, long maxValue) {
        this.minValue = minValue;
        if (maxValue < minValue) {
            throw new RuntimeException("CycleRange must have min and max value in that order.");
        }
        this.width = maxValue - minValue;
    }

    @Override
    public int applyAsInt(long operand) {
        return (int)(this.minValue + operand % this.width & Integer.MAX_VALUE);
    }
}

