/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.unary_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.Arrays;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class FieldExtractor
implements Function<String, String> {
    private static final Logger logger = LoggerFactory.getLogger(FieldExtractor.class);
    private final String fields;
    private final String splitDelim;
    private final String printDelim;
    private final int maxIdx;
    private int[] indexes;
    private ThreadLocal<StringBuilder> tlsb = ThreadLocal.withInitial(StringBuilder::new);

    @Example(value={"FieldExtractor('|,2,16')", "extract fields 2 and 16 from the input data with '|' as the delimiter"})
    public FieldExtractor(String fields) {
        this.fields = fields;
        String[] indexSpecs = fields.split(",");
        this.printDelim = indexSpecs[0];
        this.splitDelim = "\\" + indexSpecs[0];
        this.indexes = new int[indexSpecs.length - 1];
        for (int i = 1; i <= this.indexes.length; ++i) {
            this.indexes[i - 1] = Integer.valueOf(indexSpecs[i].trim()) - 1;
        }
        this.maxIdx = Arrays.stream(this.indexes).max().orElse(-1);
    }

    private int[] initIndexes(String fields) {
        return this.indexes;
    }

    @Override
    public String apply(String s) {
        String[] words = s.split(this.splitDelim);
        if (words.length < this.maxIdx) {
            logger.warn("Short read on line, indexes: " + Arrays.toString(this.indexes) + ", line:" + s + ", returning 'ERROR-UNDERRUN'");
            return "ERROR-UNDERRUN in FieldExtractor";
        }
        StringBuilder sb = this.tlsb.get();
        sb.setLength(0);
        for (int index : this.indexes) {
            sb.append(words[index]).append(this.printDelim);
        }
        sb.setLength(sb.length() - this.printDelim.length());
        return sb.toString();
    }
}

