/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.core.Bindings;
import io.virtdata.core.VirtData;
import io.virtdata.core.VirtDataDocs;
import io.virtdata.templates.BindPoint;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingsTemplate {
    private static final Logger logger = LoggerFactory.getLogger(BindingsTemplate.class);
    private List<String> bindPointNames = new ArrayList<String>();
    private List<String> specifiers = new ArrayList<String>();

    public BindingsTemplate(List<String> anchors, List<String> specs) {
        if (anchors.size() != specs.size()) {
            throw new InvalidParameterException("Anchors and Specifiers must be matched pair-wise.");
        }
        for (int i = 0; i < anchors.size(); ++i) {
            this.addFieldBinding(anchors.get(i), specs.get(i));
        }
    }

    public BindingsTemplate(List<BindPoint> bindpoints) {
        this.addFieldBindings(bindpoints);
    }

    public BindingsTemplate() {
    }

    public void addFieldBindings(List<BindPoint> bindPoints) {
        for (BindPoint bindPoint : bindPoints) {
            this.addFieldBinding(bindPoint.getAnchor(), bindPoint.getBindspec());
        }
    }

    public void addFieldBinding(String bindPointName, String genSpec) {
        this.bindPointNames.add(bindPointName);
        this.specifiers.add(genSpec);
    }

    public void addFieldBindings(Map<String, String> bindPairs) {
        for (Map.Entry<String, String> e : bindPairs.entrySet()) {
            this.bindPointNames.add(e.getKey());
            this.specifiers.add(e.getValue());
        }
    }

    public Bindings resolveBindings() {
        ArrayList dataMappers = new ArrayList();
        for (String specifier : this.specifiers) {
            Optional optionalDataMapper = VirtData.getOptionalMapper(specifier);
            if (optionalDataMapper.isPresent()) {
                dataMappers.add(optionalDataMapper.get());
                continue;
            }
            this.logAvailableDataMappers();
            throw new RuntimeException("data mapper binding was unsuccessful for , spec:" + specifier + ", see log for known data mapper names.");
        }
        return new Bindings(this, dataMappers);
    }

    private void logAvailableDataMappers() {
        VirtDataDocs.getAllNames().forEach(gn -> logger.info("DATAMAPPER " + gn));
    }

    public List<String> getBindPointNames() {
        return this.bindPointNames;
    }

    public List<String> getDataMapperSpecs() {
        return this.specifiers;
    }

    public String toString() {
        String delim = "";
        StringBuilder sb = new StringBuilder(BindingsTemplate.class.getSimpleName()).append(":");
        for (int i = 0; i < this.bindPointNames.size(); ++i) {
            sb.append(delim);
            sb.append("'").append(this.bindPointNames.get(i)).append("'");
            sb.append("=>");
            sb.append("\"").append(this.specifiers.get(i)).append("\"");
            delim = ", ";
        }
        return sb.toString();
    }

    public String toString(Object[] values) {
        String delim = "";
        StringBuilder sb = new StringBuilder(BindingsTemplate.class.getSimpleName()).append(":");
        for (int i = 0; i < this.bindPointNames.size(); ++i) {
            sb.append(delim);
            sb.append("'").append(this.bindPointNames.get(i)).append("'");
            sb.append("=>");
            sb.append("\"").append(this.specifiers.get(i)).append("\"");
            sb.append("=>[");
            sb.append(values[i]);
            sb.append("](");
            sb.append(null != values[i] ? values[i].getClass().getSimpleName() : "NULL");
            sb.append(")");
            delim = ", ";
        }
        return sb.toString();
    }
}

