/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class StringMap
implements LongFunction<Map<String, String>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction[] keyFuncs;
    private final LongFunction[] valueFuncs;
    private final Mode mode;

    @Example(value={"StringMap(HashRange(3,7),NumberNameToString(),HashRange(1300,1700))", "create a map of size 3-7 entries, with a key of type string and a value of type int (Integer by autoboxing)"})
    public StringMap(LongToIntFunction sizeFunc, LongFunction<Object> keyFunc, LongFunction<Object> valueFunc) {
        this.mode = Mode.VarSized;
        this.sizeFunc = sizeFunc;
        this.keyFuncs = new LongFunction[1];
        this.keyFuncs[0] = keyFunc;
        this.valueFuncs = new LongFunction[1];
        this.valueFuncs[0] = valueFunc;
    }

    @SafeVarargs
    @Example(value={"StringMap(NumberNameToString(),HashRange(1300,1700),NumberNameToString(),HashRange(3,7))", "create a map of size 2, with a specific function for each key and each value"})
    public StringMap(LongFunction<Object> ... objfuncs) {
        this.mode = Mode.Tuples;
        if (objfuncs.length % 2 != 0) {
            throw new RuntimeException("An even number of functions must be provided.");
        }
        int size = objfuncs.length / 2;
        this.sizeFunc = l -> size;
        this.keyFuncs = new LongFunction[size];
        this.valueFuncs = new LongFunction[size];
        for (int i = 0; i < size; ++i) {
            this.keyFuncs[i] = objfuncs[i << 1];
            this.valueFuncs[i] = objfuncs[(i << 1) + 1];
        }
    }

    @Override
    public Map<String, String> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        HashMap<String, String> map = new HashMap<String, String>(size);
        switch (this.mode) {
            case VarSized: {
                for (int i = 0; i < size; ++i) {
                    Object keyObject = this.keyFuncs[0].apply(value + (long)i);
                    Object valueObject = this.valueFuncs[0].apply(value + (long)i);
                    map.put(String.valueOf(keyObject), String.valueOf(valueObject));
                }
                break;
            }
            case Tuples: {
                for (int i = 0; i < this.keyFuncs.length; ++i) {
                    Object keyObject = this.keyFuncs[i].apply(value + (long)i);
                    Object valueObject = this.valueFuncs[i].apply(value + (long)i);
                    map.put(String.valueOf(keyObject), String.valueOf(valueObject));
                }
                break;
            }
        }
        return map;
    }

    private static enum Mode {
        VarSized,
        Tuples;

    }
}

