/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_double;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_long.Hash;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
public class HashedRangedToNonuniformDouble
implements LongToDoubleFunction {
    private final long min;
    private final long max;
    private final double length;
    private final Hash hash = new Hash();

    public HashedRangedToNonuniformDouble(long min, long max) {
        if (max <= min) {
            throw new RuntimeException("max must be >= min");
        }
        this.min = min;
        this.max = max;
        this.length = (double)max - (double)min;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.min + ":" + this.max;
    }

    @Override
    public double applyAsDouble(long input) {
        long bitImage = this.hash.applyAsLong(input);
        double value = Math.abs(Double.longBitsToDouble(bitImage));
        while (!Double.isFinite(value)) {
            bitImage = this.hash.applyAsLong(++input);
            value = Math.abs(Double.longBitsToDouble(bitImage));
        }
        value %= this.length;
        return value += (double)this.min;
    }
}

