/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_long;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class)
public class InterpolateAutoDocsInfo
implements DocFuncData {
    @Override
    public String getClassName() {
        return "Interpolate";
    }

    @Override
    public String getPackageName() {
        return "io.virtdata.libbasics.shared.from_long.to_long";
    }

    @Override
    public String getClassJavadoc() {
        return "Return a value along an interpolation curve. This allows you to sketch a basic\ndensity curve and describe it simply with just a few values. The number of values\nprovided determines the resolution of the internal lookup table that is used for\ninterpolation. The first value is always the 0.0 anchoring point on the unit interval.\nThe last value is always the 1.0 anchoring point on the unit interval. This means\nthat in order to subdivide the density curve in an interesting way, you need to provide\na few more values in between them. Providing two values simply provides a uniform\nsample between a minimum and maximum value.\n\nThe input range of this function is, as many of the other functions in this library,\nbased on the valid range of positive long values, between 0L and Long.MAX_VALUE inclusive.\nThis means that if you want to combine interpolation on this curve with the effect of\npseudo-random sampling, you need to put a hash function ahead of it in the flow.\n";
    }

    @Override
    public String getInType() {
        return "long";
    }

    @Override
    public String getOutType() {
        return "long";
    }

    @Override
    public Category[] getCategories() {
        return new Category[0];
    }

    @Override
    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("Interpolate", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("values", "double[]...");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("Interpolate(0.0d,100.0d)");
                                this.add("return a uniform long value between 0L and 100L");
                            }
                        });
                        this.add(new ArrayList<String>(){
                            {
                                this.add("Interpolate(0.0d,90.0d,95.0d,98.0d,100.0d)");
                                this.add("return a weighted long value where the first second and third quartiles are 90.0D, 95.0D, and 98.0D");
                            }
                        });
                    }
                }));
            }
        };
    }
}

