/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_string.Template;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class JoinTemplate
extends Template
implements LongFunction<String> {
    @Example(value={"JoinTemplate('--',NumberNameToString(),NumberNameToString())", "create values like `one--one`, `two-two`, ..."})
    public JoinTemplate(String delimiter, LongFunction<?> ... funcs) {
        super(JoinTemplate.templateFor("", delimiter, "", funcs), funcs);
    }

    @Example(value={"JoinTemplate('{',',','}',NumberNameToString(),LastNames())", "create values like '{one,Farrel}', '{two,Haskell}', ..."})
    public JoinTemplate(String prefix, String delimiter, String suffix, LongFunction<?> ... funcs) {
        super(JoinTemplate.templateFor(prefix, delimiter, suffix, funcs), funcs);
    }

    @Example(value={"JoinTemplate(Add(3),'[',';',']',NumberNameToString(),NumberNameToString(),NumberNameToString())", "create values like '[zero;three,six]', '[one;four,seven]', ..."})
    public JoinTemplate(LongUnaryOperator iterop, String prefix, String delimiter, String suffix, LongFunction<?> ... funcs) {
        super(iterop, JoinTemplate.templateFor(prefix, delimiter, suffix, funcs), funcs);
    }

    private static String templateFor(String prefix, String delimiter, String suffix, LongFunction<?> ... funcs) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        for (int i = 0; i < funcs.length; ++i) {
            sb.append("{}");
            sb.append(delimiter);
        }
        sb.setLength(sb.length() - delimiter.length());
        sb.append(suffix);
        return sb.toString();
    }
}

