/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.util.VirtDataFunctions;
import java.util.ArrayList;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class Template
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(Template.class);
    private static final String EXPR_BEGIN = "[[";
    private static final String EXPR_END = "]]";
    private static final ThreadLocal<StringBuilder> sb = ThreadLocal.withInitial(StringBuilder::new);
    private final String rawTemplate;
    private LongUnaryOperator iterOp;
    private String[] literals;
    private LongFunction<?>[] adaptedFuncs;

    @Example(value={"Template('{}-{}',Add(10),Hash())", "concatenate input+10, '-', and a pseudo-random long"})
    public Template(String template, Object ... funcs) {
        this(true, template, funcs);
    }

    @Example(value={"Template(true, '{}-{}', Add(10),Hash())", "throws an error, as the Add(10) function causes a narrowing conversion for a long input"})
    public Template(boolean truncate, String template, Object ... funcs) {
        this.adaptedFuncs = this.adapt(funcs, truncate);
        this.rawTemplate = template;
        this.literals = this.parseTemplate(template, funcs.length);
    }

    private LongFunction<?>[] adapt(Object[] funcs, boolean truncate) {
        ArrayList<LongFunction> adapted = new ArrayList<LongFunction>();
        for (Object func : funcs) {
            LongFunction lf = VirtDataFunctions.adapt(func, LongFunction.class, Object.class, truncate);
            adapted.add(lf);
        }
        return adapted.toArray(new LongFunction[0]);
    }

    public Template(LongUnaryOperator iterOp, String template, LongFunction<?> ... funcs) {
        this(template, funcs);
        this.iterOp = iterOp;
    }

    private String[] parseTemplate(String template, int funcCount) {
        try {
            ArrayList<String> literals = new ArrayList<String>();
            Pattern p = Pattern.compile("\\{}");
            Matcher m = p.matcher(template);
            int pos = 0;
            while (m.find()) {
                literals.add(template.substring(pos, m.start()));
                pos = m.end();
            }
            literals.add(template.substring(pos));
            if (literals.size() != funcCount + 1) {
                throw new RuntimeException("The number of {} place holders in '" + template + "' should equal the number of functions.");
            }
            return literals.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String apply(long value) {
        StringBuilder buffer = sb.get();
        buffer.setLength(0);
        buffer.append(this.literals[0]);
        if (this.literals.length > 1) {
            for (int i = 0; i < this.adaptedFuncs.length; ++i) {
                long input = this.iterOp != null ? this.iterOp.applyAsLong(value + (long)i) : value + (long)i;
                String genString = String.valueOf(this.adaptedFuncs[i].apply(input));
                buffer.append(genString);
                buffer.append(this.literals[i + 1]);
            }
        }
        return buffer.toString();
    }
}

