/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_time_types.joda;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_time_types.joda.Timezones;
import java.util.function.LongUnaryOperator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Categories(value={Category.datetime})
@ThreadSafeMapper
public class ToMillisAtStartOfHour
implements LongUnaryOperator {
    private final DateTimeZone tz;

    @Example(value={"ToMillisAtStartOfHour()", "return millisecond epoch time of the start of the hour of the provided millisecond epoch time, assuming UTC"})
    public ToMillisAtStartOfHour() {
        this(DateTimeZone.UTC.getID());
    }

    @Example(value={"ToMillisAtStartOfHour('America/Chicago')", "return millisecond epoch time of the start of the hour of the provided millisecond epoch time, using timezone America/Chicago"})
    public ToMillisAtStartOfHour(String timezoneId) {
        this.tz = Timezones.forId(timezoneId);
    }

    @Override
    public long applyAsLong(long operand) {
        return new DateTime(operand, this.tz).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0).getMillis();
    }
}

