/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.state})
public class Save
implements Function<Object, Object> {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"Save('foo')", "for the current thread, save the input object value to the named variable"})
    public Save(String name) {
        this.name = name;
        this.nameFunc = null;
    }

    @Example(value={"Save(NumberNameToString())", "for the current thread, save the current input object value to the named variable,where the variable name is provided by a function."})
    public Save(Function<Object, Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
    }

    @Override
    public Object apply(Object o) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(o)) : this.name;
        map.put(varname, o);
        return o;
    }
}

