/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;

@Categories(value={Category.state})
@ThreadSafeMapper
public class SaveInteger
implements IntUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"SaveInteger('foo')", "save the current integer value to a named variable in this thread."})
    public SaveInteger(String name) {
        this.name = name;
        this.nameFunc = null;
    }

    @Example(value={"SaveInteger(NumberNameToString())", "save the current integer value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveInteger(Function<Object, Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
    }

    @Override
    public int applyAsInt(int operand) {
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(operand)) : this.name;
        SharedState.tl_ObjectMap.get().put(varname, operand);
        return operand;
    }
}

