/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_int;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
public class CycleRange
implements IntUnaryOperator {
    private final int minValue;
    private final int width;

    @Example(value={"CycleRange(34)", "add a rotating value between 0 and 34 to the input"})
    public CycleRange(int maxValue) {
        this(0, maxValue);
    }

    public CycleRange(int minValue, int maxValue) {
        this.minValue = minValue;
        if (maxValue < minValue) {
            throw new RuntimeException("CycleRange must have min and max value in that order.");
        }
        this.width = maxValue - minValue;
    }

    @Override
    public int applyAsInt(int operand) {
        return this.minValue + operand % this.width;
    }
}

